/************************************************************************
* FILE:        hc_tclEmergencyFunctionCDDriveOFF.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of emergency function CDDriveOFF
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTIONCDDRIVEOFF_H_
#define HC_TCLEMERGENCYFUNCTIONCDDRIVEOFF_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclEmergencyFunction_Config.h"
#include "hc_tclEmergencyFunction.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

/*******************************************************************************
| Emergency function SystemShutdown configuration class definition
|-----------------------------------------------------------------------------*/
typedef hc_tclEmergencyFunction_ConfigTemplate<
		dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE, dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop,
		dp_tclHeatCtrlDPCDDRIVEOFF_DELAY, dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop>
hc_tclEmergencyFunctionCDDriveOFF_Config;

/*******************************************************************************
| Emergency function SystemShutdown class definition
|-----------------------------------------------------------------------------*/
class hc_tclEmergencyFunctionCDDriveOFF
: public hc_tclEmergencyFunction
, public hc_tclEmergencyFunctionCDDriveOFF_Config
{
public:
	// constructors and destructors
	hc_tclEmergencyFunctionCDDriveOFF();
	virtual ~hc_tclEmergencyFunctionCDDriveOFF();
};

#endif /* HC_TCLEMERGENCYFUNCTIONCDDRIVEOFF_H_ */
