/************************************************************************
* FILE:        hc_tclEmergencyFunctionBacklightOFF.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of emergency function BacklightOFF
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLEMERGENCYFUNCTIONBACKLIGHTOFF_H_
#define HC_TCLEMERGENCYFUNCTIONBACKLIGHTOFF_H_

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclEmergencyFunction_Config.h"
#include "hc_tclEmergencyFunction.h"

// datapool access
#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

/*******************************************************************************
| Emergency function BacklightOFF configuration class definition
|-----------------------------------------------------------------------------*/
typedef hc_tclEmergencyFunction_ConfigTemplate<
		dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE, dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop,
		dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY, dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop>
hc_tclEmergencyFunctionBacklightOFF_Config;

/*******************************************************************************
| Emergency function BacklightOFF class definition
|-----------------------------------------------------------------------------*/
class hc_tclEmergencyFunctionBacklightOFF
: public hc_tclEmergencyFunction
, public hc_tclEmergencyFunctionBacklightOFF_Config
{
public:
	// constructors and destructors
	hc_tclEmergencyFunctionBacklightOFF();
	virtual ~hc_tclEmergencyFunctionBacklightOFF();
};

#endif /* HC_TCLEMERGENCYFUNCTIONBACKLIGHTOFF_H_ */
