/************************************************************************
* FILE:        hc_tclEmergencyFunctionBacklightOFF.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class of emergency function SystemShutdown
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

// Basic OSAL includes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#include "hc_tclEmergencyFunctionBacklightOFF.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclEmergencyFunctionBacklightOFF.cpp.trc.h"
#endif

/*******************************************************************************
*
* FUNCTION:    hc_tclEmergencyFunctionBacklightOFF()
*
* DESCRIPTION: constructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclEmergencyFunctionBacklightOFF::hc_tclEmergencyFunctionBacklightOFF()
: hc_tclEmergencyFunction(enEmergencyFunctionID_BacklightOFF)
, hc_tclEmergencyFunctionBacklightOFF_Config()
{
   ETG_TRACE_USR4(("hc_tclEmergencyFunctionBacklightOFF() entered."));
}

/*******************************************************************************
*
* FUNCTION:    ~hc_tclEmergencyFunctionBacklightOFF()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*******************************************************************************/
hc_tclEmergencyFunctionBacklightOFF::~hc_tclEmergencyFunctionBacklightOFF()
{
   ETG_TRACE_USR4(("~hc_tclEmergencyFunctionSystemShutdown() entered."));
}




