/************************************************************************
* FILE:        I_hc_tclEmergencyFunctionControl.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class to control all emergency function
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 11.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef I_HC_TCLEMERGENCYFUNCTIONCONTROL_H_
#define I_HC_TCLEMERGENCYFUNCTIONCONTROL_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "hc_AppMain.h"

#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclThermalSensor_Types.h"

class I_hc_tclEmergencyFunctionControl : public hc_tclBaseIf
{
public:
   // constructor
   I_hc_tclEmergencyFunctionControl(tVoid);
   I_hc_tclEmergencyFunctionControl(const hc_tclAppMain* poMainAppl) : hc_tclBaseIf(poMainAppl) {;};
   // destructor
   virtual ~I_hc_tclEmergencyFunctionControl(){};

   virtual const tChar* getIfName() const { return "I_hc_tclEmergencyFunctionControl"; };

	virtual tenEmergencyFunctionState enGetFunctionState(tenEmergencyFunctionID enFunctionID) const = 0;
};

#endif /* I_HC_TCLEMERGENCYFUNCTIONCONTROL_H_ */
