/************************************************************************
* FILE:        hc_tclDiagnosisListener.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class for diag listener
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 06.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLDIAGNOSISLISTENER_H_
#define HC_TCLDIAGNOSISLISTENER_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

// +++diaglib+++  Specify what kind of diagnostic services you provide. Consult documentation for details +++
#define DIAGLIB_INCLUDE_DIAGNOSIS_DATA
#include "diaglib_if.h"

//include base class
#include "I_hc_tclDiagnosisListener.h"

class hc_tclDiagnosisDataListener;

#define HC_DIAGLISTENER_CLNAME                  "hc_tclDiagnosisListener"

class hc_tclDiagnosisListener : public I_hc_tclDiagnosisListener
{
public:
   // Constructors and destructors
	hc_tclDiagnosisListener(tVoid);
	hc_tclDiagnosisListener(const hc_tclAppMain* poMainAppl);
   virtual ~hc_tclDiagnosisListener();

   virtual const tChar* getName() const { return HC_DIAGLISTENER_CLNAME; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

protected:
   // +++diaglib+++
   diaglib::tclServiceDiaglib* m_poServiceDiaglib;
   // +++ Listeners you create +++
   hc_tclDiagnosisDataListener* m_poDiagnosisDataListener;

};


#endif /* HC_TCLDIAGNOSISLISTENER_H_ */
