/*
 * hc_tclDiagnosisListener.cpp
 *
 *  Created on: Jan 9, 2017
 *      Author: bne2hi
 */
/************************************************************************
* FILE:        hc_tclDiagnosisListener.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: implementation of class for diag listener
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 06.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "hc_tclDiagnosisListener.h"
#include "hc_tclDiagnosisDataListener.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclDiagnosisListener.cpp.trc.h"
#endif

// datapool access
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

/*************************************************************************
*
* FUNCTION:    hc_tclDiagnosisListener()
*
* DESCRIPTION: constructor
*
* PARAMETER:   const hc_tclAppMain* poMainAppl: main - object of this application
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclDiagnosisListener::hc_tclDiagnosisListener(const hc_tclAppMain* poMainAppl)
: I_hc_tclDiagnosisListener(poMainAppl)
{
   ETG_TRACE_USR4(("hc_tclDiagnosisListener() entered."));

   m_poServiceDiaglib = OSAL_NULL;
   m_poDiagnosisDataListener = OSAL_NULL;
}

/*************************************************************************
*
* FUNCTION:    ~hc_tclDiagnosisListener()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclDiagnosisListener::~hc_tclDiagnosisListener()
{
   ETG_TRACE_USR4(("~hc_tclDiagnosisListener() entered."));
   if(OSAL_NULL != m_poDiagnosisDataListener)
   {
	   OSAL_DELETE m_poDiagnosisDataListener;
	   m_poDiagnosisDataListener = OSAL_NULL;
   }
   if(OSAL_NULL != m_poServiceDiaglib)
   {
	   OSAL_DELETE m_poServiceDiaglib;
	   m_poServiceDiaglib = OSAL_NULL;
   }
}

/*******************************************************************************
*
* FUNCTION: 	vHandleMessage()
*
* DESCRIPTION: 	handler for internal messages
*
* PARAMETER:   	hc_tclBaseIf::TMsg* pMsg: reference of received message
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclDiagnosisListener::vHandleMessage(hc_tclBaseIf::TMsg* pMsg)
{
   HC_NULL_POINTER_CHECK(pMsg);
   ETG_TRACE_USR4(("vHandleMessage() entered %u -> data: %d.", ETG_ENUM(HC_INT_MSG , (tU32)pMsg->eCmd), pMsg->u.u32Data));

   switch (pMsg->eCmd)
   {
   case hc_tclBaseIf::eUpdateSimuMode:
   	   {
   		   // dummy
       }
	   break;
   default:
       {
       }
	   break;
   }
}

/*******************************************************************************
*
* FUNCTION: 	vHandleTraceMessage()
*
* DESCRIPTION: 	handler for trace command messages
*
* PARAMETER:   	const tUChar* puchData: reference of received message
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclDiagnosisListener::vHandleTraceMessage(const tUChar* puchData)
{
	HC_NULL_POINTER_CHECK(puchData);
	ETG_TRACE_USR4(("vHandleTraceMessage() entered (data: 0x%08x).", puchData ));
}

/*******************************************************************************
*
* FUNCTION: 	vGetReferences(tVoid)
*
* DESCRIPTION: 	Function to get all reference needed by this class.
* 				A reference should always be the Interface class of the object
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclDiagnosisListener::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vGetReferences() entered."));

   hc_tclAppMain* _poApp = hc_tclAppMain::theServer();

   // +++diaglib+++  Create diaglib-service
   //---------------------------------------
   if((OSAL_NULL == m_poServiceDiaglib) && (OSAL_NULL != _poApp))
   {

	   m_poServiceDiaglib = OSAL_NEW diaglib::tclServiceDiaglib(_poApp, 0x01);
	   if (OSAL_NULL == m_poServiceDiaglib)
	   {
		   ETG_TRACE_ERR((" vGetReferences: DIAGLib service could not created!"));
		   NORMAL_M_ASSERT_ALWAYS();
	   }
	   else
	   {
	      ETG_TRACE_USR3((" vGetReferences: DIAGLib service created successful"));

	      // +++ Get DiagnosisData Interface
	      diaglib::tclDiagnosisDataIF* m_poDiagnosisDataIF = m_poServiceDiaglib->poGetDiagData();

	      // +++ Create your listener objects here +++
	      m_poDiagnosisDataListener = OSAL_NEW hc_tclDiagnosisDataListener(m_poDiagnosisDataIF, _poApp);

	      // +++ Register your listeners here +++
	      if (m_poDiagnosisDataListener != NULL)
	      {
		      ETG_TRACE_USR3((" vGetReferences: DiagDataListener created successful and will register now."));
	          m_poDiagnosisDataIF->vRegisterListener( DATAID_FAN_STATISTICS, m_poDiagnosisDataListener );
	      }
	      else
	      {
		      ETG_TRACE_ERR((" vGetReferences: DiagDataListener could not created!"));
	      }
	   }
   }
   else
   {
	   ETG_TRACE_ERR((" vGetReferences: DIAGLib service is 0x%08x and app is 0x%08x!",
			   m_poServiceDiaglib, _poApp ));
   }
}

/*******************************************************************************
*
* FUNCTION: 	tVoid vStartCommunication()
*
* DESCRIPTION: 	Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclDiagnosisListener::vStartCommunication(tVoid)
{
   HC_NULL_POINTER_CHECK(hc_tclAppMain::theServer());
   ETG_TRACE_USR4(("vStartCommunication() entered."));
}

/*******************************************************************************
*
* FUNCTION: 	tVoid vTraceInfo()
*
* DESCRIPTION: 	Function to trace
*
* PARAMETER: 	None.
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tVoid hc_tclDiagnosisListener::vTraceInfo()
{
   ETG_TRACE_USR4(("vTraceInfo() entered."));
}
