/************************************************************************
* FILE:        hc_tclDiagnosisDataListener.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class for diag client handler of data listener
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                      | Modification
* 09.01.2017| CM-Cl1/ERN2-E Bernard       | init
*
*************************************************************************/

#ifndef HC_TCLDIAGNOSISDATALISTENER_H_
#define HC_TCLDIAGNOSISDATALISTENER_H_

// +++diaglib+++  Specify what kind of diagnostic services you provide. Consult documentation for details +++
#define DIAGLIB_INCLUDE_DIAGNOSIS_DATA
#include "diaglib_if.h"

#include "hc_AppMain.h"

class hc_tclDiagnosisDataListener : public diaglib::tclDiagnosisDataListenerIF
{
public:

   hc_tclDiagnosisDataListener(diaglib::tclDiagnosisDataIF*, hc_tclAppMain*);
   virtual ~hc_tclDiagnosisDataListener();

   virtual tU32 vOnDiagnosisDataRead (
                                      tU32 u32DiagDataId,
                                      diaglib::tContext MsgContext
                                      );

   virtual tU32 vOnDiagnosisDataWrite (
                                   tU32 u32DiagDataId,
                                   const diaglib::tclParameterVector& oParamVector,
                                   diaglib::tContext MsgContext
                                   );

private:
   // +++ Pointer to application +++
   hc_tclAppMain* m_poAppMain;
   // +++ Interface pointer to send responses to, adjust type according to listener type +++
   diaglib::tclDiagnosisDataIF* m_poDiagnosisDataIF;
};

#endif /* HC_TCLDIAGNOSISDATALISTENER_H_ */
