/************************************************************************
* FILE:        hc_tclDiagnosisDataListener.cpp
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: implementation of class for diag client handler of data
*              listener
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                      | Modification
* 09.01.2017| CM-Cl1/ERN2-E Bernard       | init
*
*************************************************************************/

/*******************************************************************************
| includes: system- and project- includes
|-----------------------------------------------------------------------------*/
// Basic OSAL includes
#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

/*******************************************************************************
| set own module id
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| includes: needed interfaces from external components
|-----------------------------------------------------------------------------*/


/*******************************************************************************
| includes: internal and external interfaces from this component
|-----------------------------------------------------------------------------*/

#include "hc_tclDiagnosisDataListener.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_HEATCTRL_APPLICATION
#include "trcGenProj/Header/hc_tclDiagnosisDataListener.cpp.trc.h"
#endif

// datapool access
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_heatctrl_if.h"

#include "I_hc_tclFANControl.h"

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable definition (scope: global)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| variable definition (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototype (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementation (scope: module-local)
|-----------------------------------------------------------------------------*/

/*************************************************************************
*
* FUNCTION:    hc_tclDiagnosisDataListener()
*
* DESCRIPTION: constructor
*
* PARAMETER:   diaglib::tclDiagnosisDataIF* poDiagnosisDataIF: reference
*                 of diag data interface object
*              hc_tclAppMain* poAppMain: reference of main application
*                 object
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclDiagnosisDataListener::hc_tclDiagnosisDataListener(diaglib::tclDiagnosisDataIF* poDiagnosisDataIF, hc_tclAppMain* poAppMain)
   : m_poAppMain(poAppMain),
     m_poDiagnosisDataIF(poDiagnosisDataIF)
{
}

/*************************************************************************
*
* FUNCTION:    ~hc_tclDiagnosisDataListener()
*
* DESCRIPTION: destructor
*
* PARAMETER:   none
*
* RETURNVALUE: none
*
*************************************************************************/
hc_tclDiagnosisDataListener::~hc_tclDiagnosisDataListener()
{
   m_poDiagnosisDataIF = OSAL_NULL;
   m_poAppMain = OSAL_NULL;
}

/*******************************************************************************
*
* FUNCTION: 	vOnDiagnosisDataRead()
*
* DESCRIPTION: 	handler for diag data read
*
* PARAMETER:   	tU32 u32DiagDataId: diag data id
*               diaglib::tContext MsgContext: diag data message context
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tU32 hc_tclDiagnosisDataListener::vOnDiagnosisDataRead (
                                      tU32 u32DiagDataId,
                                      diaglib::tContext MsgContext
                                      )
{
   ETG_TRACE_USR4(("vOnDiagnosisDataRead(data_id: %d, msg_context: 0x%08x) entered.", u32DiagDataId, &MsgContext));

   tU32 _u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;

   if(OSAL_NULL == m_poDiagnosisDataIF)
   {
      // +++ Error Trace +++
      ETG_TRACE_ERR(("vOnDiagnosisDataRead: diag data interface uninitialized!"));
   }
   else if (u32DiagDataId == DATAID_FAN_STATISTICS)
   {
      I_hc_tclFANControl* _poFanCtrl = (OSAL_NULL != m_poAppMain)?dynamic_cast<I_hc_tclFANControl*>(m_poAppMain->getHandler("I_hc_tclFANControl")):OSAL_NULL;
      if (OSAL_NULL != _poFanCtrl)
      {
         diaglib::tclParameterVector oResultVector;
         diaglib::trParameter rParam;
         rParam.enType = diaglib::EN_PARAMETER_TYPE_U16;
         oResultVector.assign(DATAID_FAN_STATISTICS_READ_RESULT_LEN, rParam);
         // set fan activation count
         oResultVector[DATAID_FAN_STATISTICS_READ_RESULT_u16FanActivationCounter].u16Value = (tU16)_poFanCtrl->u32GetActivationCounter(enFANID_SYSTEM, enFANCtrlMode_AUTO, enOperationtime);
         // set fan activation duration in minutes
         oResultVector[DATAID_FAN_STATISTICS_READ_RESULT_u16FanActivationDuration].u16Value = (tU16)HC_C_U32_CONVERT_MS2MIN(_poFanCtrl->u32GetActivationDuration(enFANID_SYSTEM, enFANCtrlMode_AUTO, enOperationtime));

         // +++ Send the response +++
         if(TRUE == m_poDiagnosisDataIF->bSendDiagnosisDataResult( diaglib::EN_DIAGDATA_OK,
        		 oResultVector, MsgContext))
         {
            // +++ Trace info +++
            ETG_TRACE_USR3(("vOnDiagnosisDataRead: bSendDiagnosisDataResult for data id %d successful.", u32DiagDataId ));
         }
         else
         {
            // +++ Trace error +++
            ETG_TRACE_ERR(("vOnDiagnosisDataRead: bSendDiagnosisDataResult for data id %d failed!",	u32DiagDataId ));
         }
         _u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
      }
      else
      {
          ETG_TRACE_ERR(("vOnDiagnosisDataRead: no fan control access to fill data id %d!",	u32DiagDataId ));
      }
   }
   else
   {
      // +++ Error Trace +++
      ETG_TRACE_ERR(("vOnDiagnosisDataRead: reading of unhandled data_id: %d with msg_context: 0x%08x failed.", u32DiagDataId, &MsgContext));
   }
   return _u32Return;
}

/*******************************************************************************
*
* FUNCTION: 	vOnDiagnosisDataWrite()
*
* DESCRIPTION: 	handler for diag data write
*
* PARAMETER:   	tU32 u32DiagDataId: diag data id
*               const diaglib::tclParameterVector& oParamVector
*               diaglib::tContext MsgContext: diag data message context
*
* RETURNVALUE: 	None.
*
*******************************************************************************/
tU32 hc_tclDiagnosisDataListener::vOnDiagnosisDataWrite (
                                   tU32 u32DiagDataId,
                                   const diaglib::tclParameterVector& oParamVector,
                                   diaglib::tContext MsgContext
                                   )
{
   ETG_TRACE_USR4(("vOnDiagnosisDataWrite(data_id: %d, param: 0x%08x, msg_context: 0x%08x) entered.",
		   u32DiagDataId, &oParamVector, &MsgContext));

   ETG_TRACE_ERR(("vOnDiagnosisDataWrite: unsupported function for data id %d!",
  		 u32DiagDataId ));

   return diaglib::U32_DIAGLIB_RETURN_NOT_OK;
}
