/************************************************************************
* FILE:        hc_ClientiMXtemp.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: class for client handler iMX temperature
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 06.03.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_CLIENTIMXTEMP_H_
#define HC_CLIENTIMXTEMP_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_hc_ClientiMXtemp.h"

class I_hc_tclSimuMode;

#define HC_CLIENTIMXTEMP_CYCLETIME                                            30
#define HC_CLIENTIMXTEMP_DEVICE "/sys/devices/virtual/thermal/thermal_zone0/temp"

class hc_ClientiMXtemp : public I_hc_ClientiMXtemp
{
public:
   // Constructors and destructors
   hc_ClientiMXtemp(tVoid);
   hc_ClientiMXtemp(const hc_tclAppMain* poMainAppl);
   virtual ~hc_ClientiMXtemp();

   virtual const tChar* getName() const { return "hc_ClientiMXtemp"; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tBool bIsServiceAvailable() {return _bAvailable;};

   virtual tU32 u32GetPollingCycleTime(tVoid) const;
   // ServiceAvailableIF
   virtual tVoid onAvailable(tVoid);
   virtual tVoid onUnavailable(tVoid);
   // ClientiMXtempCallbackIf interface
   virtual tVoid onGET_TEMP(tS32 Temperature);
   // I_hc_ClientiMXtemp interface (to send messages)
   virtual tVoid sendIMXTEMP_TemperatureGet();

   enum tenClientiMXtemp_SensorID{
	   enClientiMXtemp_SensorID_IMX = 0,
	   enClientiMXtemp_SensorID_MAX
   };
protected:
   hc_tclBaseIf::TMsg m_aoThermalInfo[enClientiMXtemp_SensorID_MAX];
   // polling of iMX temperature
   static OSAL_tpfCallback cb_vTimerIMXTemp(tVoid* pArg);
   hc_tclBaseIf::TMsg m_oTriggerIMXTemp;
   OSAL_tTimerHandle m_hTimerIMXTemp;
   tBool _bAvailable;
   tU8 m_u8PollingCycleTime;
   tChar m_strDevice[2049];
   // simulation mode
   I_hc_tclSimuMode* m_poSimuMode;
};

#endif /* HC_CLIENTIMXTEMP_H_ */
