/************************************************************************
* FILE:        hc_tclSimuMode.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: common simulation mode class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 05.02.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLSIMUMODE_H_
#define HC_TCLSIMUMODE_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

//include base class
#include "I_hc_tclSimuMode.h"

class hc_tclSimuMode : public I_hc_tclSimuMode
{
public:
    // constructors and destructors
	hc_tclSimuMode(tVoid);
	hc_tclSimuMode(const hc_tclAppMain* poMainAppl);
	virtual ~hc_tclSimuMode();

   virtual const tChar* getName() const { return "hc_tclSimuMode"; };

   virtual tVoid vHandleMessage(hc_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   virtual tBool bGetSimuMode(tVoid) const {return m_bState;};
   tVoid vSetSimuMode(tBool bActive);

protected:
   virtual tVoid vHandleTraceCmd_GetSimuMode(const tUChar* puchData);
   virtual tVoid vHandleTraceCmd_SetSimuMode(const tUChar* puchData);
   // status of simulation mode
   tBool m_bState;
   // internal broadcast message for simulation mode
   hc_tclBaseIf::TMsg m_msgSimuMode;
};

#endif /* HC_TCLSIMUMODE_H_ */
