/************************************************************************
* FILE:        hc_tclCfgMgr_PDDTHM.h
* PROJECT:
* SW-COMPONENT:fc_heatctrl
*----------------------------------------------------------------------
*
* DESCRIPTION: definition of common PDD thermalManagment class
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 24.06.2015| CM-AI/EPB2 Bernard | init
*
*************************************************************************/

#ifndef HC_TCLCFGMGR_PDDTHM_H_
#define HC_TCLCFGMGR_PDDTHM_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#ifndef DP_S_IMPORT_INTERFACE_FI
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h" // could also be used
#endif //#ifndef DP_S_IMPORT_INTERFACE_FI

#include "hc_tclCfgMgr_Types.h"
#include "hc_tclThermalSensor_Types.h"

//******************************************************************************
// helper class for PDD threshold
//******************************************************************************
class hc_tclCfgMgr_PDDThresholdBase
{
public:
	// constructors / destructors
	hc_tclCfgMgr_PDDThresholdBase();
	virtual ~hc_tclCfgMgr_PDDThresholdBase(){;};
	// access to configuration state
	tBool bIsKDSLoaded(tVoid) const {return m_bKDSLoaded;};
	tBool bIsKDSConfigValid(tenKDSDataSensor enSensorIdx, tenKDSDataSensorThreshold enThresholdIdx) const;
	tBool bIsConfigChanged(tVoid) const;
	virtual tBool bIsPDDInitialized(tVoid) const {return TRUE;};
	tBool bIsPDDUpdated(tVoid) const {return m_bPDDUpdated;};
	// access to KDS values
	inline tS16 s16GetKDSThreshold(tVoid) const {return m_s16KDSThreshold;};
	inline tU8 u8GetKDSHysteresis(tVoid) const {return m_u8KDSHysteresis;};
	inline tU16 u16GetKDSTimeDelay(tVoid) const {return m_u16KDSTimeDelay;};
	// access to PDD values
	virtual tS16 s16GetPDDThreshold(tVoid) const {return 0;};
	virtual tBool bSetPDDThreshold(tVoid) {return FALSE;};
	virtual tU8 u8GetPDDHysteresis(tVoid) const {return 0;};
	virtual tBool bSetPDDHysteresis(tVoid) {return FALSE;};
	virtual tU16 u16GetPDDTimeDelay(tVoid) const {return 0;};
	virtual tBool bSetPDDTimeDelay(tVoid) {return FALSE;};
	// deserialize of raw KDS data
	tU8 u8Deserialize(const tU8 au8KDSBuffer[], const tU8 u8Size, const tU8 u8StartIndex);
	// update PDD configuration
	tBool bUpdatePDD(tBool bAnyCase);
	// trace info
	tVoid vTraceInfo(tenKDSDataSensor enSensorIdx, tenKDSDataSensorThreshold enThresholdIdx, const tChar strIdentAttr[]) const;
protected:
	tS16 m_s16KDSThreshold;
	tU16 m_u16KDSTimeDelay;
	tU8 m_u8KDSHysteresis;
	tBool m_bKDSLoaded : 1;
	tBool m_bPDDUpdated : 1;
};
template< class TS16DP_PDDThreshold, class TU8DP_PDDHysteresis, class TU16DP_PDDTimaDelay>
class hc_tclCfgMgr_PDDThresholdTemplate : public hc_tclCfgMgr_PDDThresholdBase
{
public:
	// constructors / destructors
	hc_tclCfgMgr_PDDThresholdTemplate():hc_tclCfgMgr_PDDThresholdBase(){;};
	virtual ~hc_tclCfgMgr_PDDThresholdTemplate(){;};
	// access to configuration state
	virtual tBool bIsPDDInitialized(tVoid) const {
		TS16DP_PDDThreshold _oDP_PDD_Threshold;
		if (DP_S32_NO_ERR != _oDP_PDD_Threshold.s32GetStatus())
			return FALSE;
		TU8DP_PDDHysteresis _oDP_PDD_Hysteresis;
		if (DP_S32_NO_ERR != _oDP_PDD_Hysteresis.s32GetStatus())
			return FALSE;
		TU16DP_PDDTimaDelay _oDP_PDD_TimeDelay;
		if (DP_S32_NO_ERR != _oDP_PDD_TimeDelay.s32GetStatus())
			return FALSE;
		return TRUE;
	};
	// access to PDD values
	virtual tS16 s16GetPDDThreshold(tVoid) const {
		TS16DP_PDDThreshold _oDP_PDD_Threshold;
		return _oDP_PDD_Threshold.tGetData();
	};
	virtual tBool bSetPDDThreshold(tVoid) {
		TS16DP_PDDThreshold _oDP_PDD_Threshold;
		return (DP_S32_NO_ERR == _oDP_PDD_Threshold.s32SetData(s16GetKDSThreshold()));
	};
	virtual tU8 u8GetPDDHysteresis(tVoid) const {
		TU8DP_PDDHysteresis _oDP_PDD_Hysteresis;
		return _oDP_PDD_Hysteresis.tGetData();
	};
	virtual tBool bSetPDDHysteresis(tVoid) {
		TU8DP_PDDHysteresis _oDP_PDD_Hysteresis;
		return (DP_S32_NO_ERR == _oDP_PDD_Hysteresis.s32SetData(u8GetKDSHysteresis()));
	};
	virtual tU16 u16GetPDDTimeDelay(tVoid) const {
		TU16DP_PDDTimaDelay _oDP_PDD_TimeDelay;
		return _oDP_PDD_TimeDelay.tGetData();
	};
	virtual tBool bSetPDDTimeDelay(tVoid) {
		TU16DP_PDDTimaDelay _oDP_PDD_TimeDelay;
		return (DP_S32_NO_ERR == _oDP_PDD_TimeDelay.s32SetData(u16GetKDSTimeDelay()));
	};
};

//******************************************************************************
// helper class for PDD sensor data
//******************************************************************************
class hc_tclCfgMgr_PDDSensorConfigBase
{
public:
	// constructors / destructors
	hc_tclCfgMgr_PDDSensorConfigBase();
	virtual ~hc_tclCfgMgr_PDDSensorConfigBase();
	// access to configuration state
	tBool bIsKDSLoaded(tVoid) const {return m_bKDSLoaded;};
	tBool bIsKDSConfigValid(tenKDSDataSensor enSensorIdx) const;
	tBool bIsConfigChanged(tVoid) const;
	virtual tBool bIsPDDInitialized(tVoid) const {return TRUE;};
	tBool bIsPDDUpdated(tVoid) const {return m_bPDDUpdated;};
	// access to KDS values
	inline tU8 u8GetKDSSensorID(tVoid) const {return m_u8KDSSensorID;};
	tU8 u8GetKDSModulID(tVoid) const;
	inline tS16 s16GetKDSMaxTemp(tVoid) const {return m_s16KDSMaxTemp;};
	inline tS16 s16GetKDSMinTemp(tVoid) const {return m_s16KDSMinTemp;};
	// access to PDD values
	virtual tU8 u8GetPDDModulID(tVoid) const {return 0;};
	virtual tBool bSetPDDModulID(tVoid) {return FALSE;};
	virtual tS16 s16GetPDDMaxTemp(tVoid) const {return 0;};
	virtual tBool bSetPDDMaxTemp(tVoid) {return FALSE;};
	virtual tS16 s16GetPDDMinTemp(tVoid) const {return 0;};
	virtual tBool bSetPDDMinTemp(tVoid) {return FALSE;};
	// access to thresholds
	inline hc_tclCfgMgr_PDDThresholdBase* poGetThreshold(tenKDSDataSensorThreshold enThreshold) const
	{
		if (enKDSDataSensorThreshold_MAX > enThreshold)
			return m_apoThresholds[enThreshold];
		return OSAL_NULL;
	};
	// deserialize of raw KDS data
	tU8 u8Deserialize(const tU8 au8KDSBuffer[], const tU8 u8Size, const tU8 u8StartIndex);
	// update PDD configuration
	tBool bUpdatePDD(tBool bAnyCase);
	// trace info
	tVoid vTraceInfo(tenKDSDataSensor enSensorIdx, const tChar strIdentAttr[]) const;
protected:
	hc_tclCfgMgr_PDDThresholdBase* m_apoThresholds[enKDSDataSensorThreshold_MAX];
	tS16 m_s16KDSMaxTemp;
	tS16 m_s16KDSMinTemp;
	tU8 m_u8KDSSensorID;
	tBool m_bKDSLoaded : 1;
	tBool m_bPDDUpdated : 1;
};
template< class TU8DP_PDDSensorID, class TS16DP_PDDMaxTemp, class TS16DP_PDDMinTemp,
class TThresholdCriticalHigh, class TThresholdHigh, class TThresholdLow, class TThresholdCriticalLow
> class hc_tclCfgMgr_PDDSensorConfigTemplate : public hc_tclCfgMgr_PDDSensorConfigBase
{
public:
	hc_tclCfgMgr_PDDSensorConfigTemplate() : hc_tclCfgMgr_PDDSensorConfigBase() {
		m_apoThresholds[enKDSDataSensorThreshold_CriticalHigh] = &this->m_oThresholdCriticalHigh;
		m_apoThresholds[enKDSDataSensorThreshold_High] = &this->m_oThresholdHigh;
		m_apoThresholds[enKDSDataSensorThreshold_Low] = &this->m_oThresholdLow;
		m_apoThresholds[enKDSDataSensorThreshold_CriticalLow] = &this->m_oThresholdCriticalLow;
	};
	virtual ~hc_tclCfgMgr_PDDSensorConfigTemplate(){
		m_apoThresholds[enKDSDataSensorThreshold_CriticalHigh] = OSAL_NULL;
		m_apoThresholds[enKDSDataSensorThreshold_High] = OSAL_NULL;
		m_apoThresholds[enKDSDataSensorThreshold_Low] = OSAL_NULL;
		m_apoThresholds[enKDSDataSensorThreshold_CriticalLow] = OSAL_NULL;
	};
	// access to configuration state
	virtual tBool bIsPDDInitialized(tVoid) const {
		TU8DP_PDDSensorID _oDP_PDD_SensorID;
		if (DP_S32_NO_ERR != _oDP_PDD_SensorID.s32GetStatus())
			return FALSE;
		TS16DP_PDDMaxTemp _oDP_PDD_MaxTemp;
		if (DP_S32_NO_ERR != _oDP_PDD_MaxTemp.s32GetStatus())
			return FALSE;
		TS16DP_PDDMinTemp _oDP_PDD_MinTemp;
		if (DP_S32_NO_ERR != _oDP_PDD_MinTemp.s32GetStatus())
			return FALSE;
		for (tU8 _u8Index = 0; (tU8)enKDSDataSensorThreshold_MAX > _u8Index; ++_u8Index)
		{
			if (OSAL_NULL != m_apoThresholds[_u8Index] && FALSE == m_apoThresholds[_u8Index]->bIsPDDInitialized())
				return FALSE;
		}
		return TRUE;
	};
	// access to PDD values
	virtual tU8 u8GetPDDModulID(tVoid) const {
		TU8DP_PDDSensorID _oDP_PDD_SensorID;
		return _oDP_PDD_SensorID.tGetData();
	};
	virtual tBool bSetPDDModulID(tVoid) {
		TU8DP_PDDSensorID _oDP_PDD_SensorID;
		return (DP_S32_NO_ERR == _oDP_PDD_SensorID.s32SetData(u8GetKDSModulID()));
	};
	virtual tS16 s16GetPDDMaxTemp(tVoid) const {
		TS16DP_PDDMaxTemp _oDP_PDD_MaxTemp;
		return _oDP_PDD_MaxTemp.tGetData();
	};
	virtual tBool bSetPDDMaxTemp(tVoid) {
		TS16DP_PDDMaxTemp _oDP_PDD_MaxTemp;
		return (DP_S32_NO_ERR == _oDP_PDD_MaxTemp.s32SetData(s16GetKDSMaxTemp()));
	};
	virtual tS16 s16GetPDDMinTemp(tVoid) const {
		TS16DP_PDDMinTemp _oDP_PDD_MinTemp;
		return _oDP_PDD_MinTemp.tGetData();
	};
	virtual tBool bSetPDDMinTemp(tVoid) {
		TS16DP_PDDMinTemp _oDP_PDD_MinTemp;
		return (DP_S32_NO_ERR == _oDP_PDD_MinTemp.s32SetData(s16GetKDSMinTemp()));
	};
protected:
	TThresholdCriticalHigh m_oThresholdCriticalHigh;
	TThresholdHigh m_oThresholdHigh;
	TThresholdLow m_oThresholdLow;
	TThresholdCriticalLow m_oThresholdCriticalLow;
};

//******************************************************************************
// class for PDD configuration of thermal management
//******************************************************************************
class hc_tclCfgMgr_PDDTHMBase
{
public:
    // constructors and destructors
	hc_tclCfgMgr_PDDTHMBase(tVoid);
	virtual ~hc_tclCfgMgr_PDDTHMBase();
	// access to configuration state
	tBool bIsKDSLoaded(tVoid) const {return m_bKDSLoaded;};
	tBool bIsKDSConfigValid(tVoid) const;
	tBool bIsConfigChanged(tVoid) const;
	virtual tBool bIsPDDInitialized(tVoid) const {return TRUE;};
	tBool bIsPDDUpdated(tVoid) const {return m_bPDDUpdated;};
	// access to KDS values
	inline tU8 u8GetKDSVersion(tVoid) const {return m_u8Version;};
	inline tU16 u16GetKDSVersion(tVoid) const {return (tU16)m_u8Version;};
	// access to PDD values
	virtual tU16 u16GetPDDVersion(tVoid) const {return 0;};
	virtual tBool bSetPDDVersion(tVoid) {return FALSE;};
	virtual tU8 u8GetPDDReserved(tVoid) const {return 0;};
	virtual tBool bSetPDDReserved(tVoid) {return FALSE;};
	// access to thresholds
	inline hc_tclCfgMgr_PDDSensorConfigBase* poGetSensor(tenKDSDataSensor enSensorIndex) const
	{
		if (enKDSDataSensor_MAX > enSensorIndex)
			return m_apoSensors[enSensorIndex];
		return OSAL_NULL;
	};
	// deserialize of raw KDS data
	tU8 u8Deserialize(const tU8 au8KDSBuffer[], const tU8 u8Size, const tU8 u8StartIndex);
	// update PDD configuration
	tBool bUpdatePDD(tBool bAnyCase=FALSE);
	// trace info
	tVoid vTraceInfo(tVoid) const;
	tVoid vTraceInfo(const char* strIdentifier) const;
	// convert PDD Sensor ID to KDS Sensor ID
	tenKDSDataSensorID enConvert2KDSSensorID(tU8 u8PDDSensorID) const;
	// convert KDS Sensor ID to Sensor ID
	tenThermalSensorID enConvert2SensorID(tenKDSDataSensorID enKDSSensorID) const;
protected:
	hc_tclCfgMgr_PDDSensorConfigBase* m_apoSensors[enKDSDataSensor_MAX];
	tU8 m_u8Version;
	tBool m_bKDSLoaded : 1;
	tBool m_bPDDUpdated : 1;
};
template< class TU16DP_PDDVersion,
class TSensor1, class TSensor2, class TSensor3, class TSensor4, class TSensor5,
class TU8DP_PDDReserved
> class hc_tclCfgMgr_PDDTHMTemplate : public hc_tclCfgMgr_PDDTHMBase
{
public:
    // constructors and destructors
	hc_tclCfgMgr_PDDTHMTemplate() : hc_tclCfgMgr_PDDTHMBase() {
		m_apoSensors[enKDSDataSensor_01] = &this->m_oSensor1;
		m_apoSensors[enKDSDataSensor_02] = &this->m_oSensor2;
		m_apoSensors[enKDSDataSensor_03] = &this->m_oSensor3;
		m_apoSensors[enKDSDataSensor_04] = &this->m_oSensor4;
		m_apoSensors[enKDSDataSensor_05] = &this->m_oSensor5;
	};
	virtual ~hc_tclCfgMgr_PDDTHMTemplate(){
		m_apoSensors[enKDSDataSensor_01] = OSAL_NULL;
		m_apoSensors[enKDSDataSensor_02] = OSAL_NULL;
		m_apoSensors[enKDSDataSensor_03] = OSAL_NULL;
		m_apoSensors[enKDSDataSensor_04] = OSAL_NULL;
		m_apoSensors[enKDSDataSensor_05] = OSAL_NULL;
	};
	// access to configuration state
	virtual tBool bIsPDDInitialized(tVoid) const {
		TU16DP_PDDVersion _oDP_PDD_Version;
		if (DP_S32_NO_ERR != _oDP_PDD_Version.s32GetStatus())
			return FALSE;
		for (tU8 _u8Index = 0; (tU8)enKDSDataSensor_MAX > _u8Index; ++_u8Index)
		{
			if (OSAL_NULL != m_apoSensors[_u8Index] && FALSE == m_apoSensors[_u8Index]->bIsPDDInitialized())
				return FALSE;
		}
		TU8DP_PDDReserved _oDP_PDD_Reserved;
		if (DP_S32_NO_ERR != _oDP_PDD_Reserved.s32GetStatus())
			return FALSE;
		return TRUE;
	};
	// access to PDD values
	virtual tU16 u16GetPDDVersion(tVoid) const {
		TU16DP_PDDVersion _oDP_PDD_Version;
		return _oDP_PDD_Version.tGetData();
	};
	virtual tBool bSetPDDVersion(tVoid) {
		TU16DP_PDDVersion _oDP_PDD_Version;
		return (DP_S32_NO_ERR == _oDP_PDD_Version.s32SetData(u16GetKDSVersion()));
	};
	virtual tU8 u8GetPDDReserved(tVoid) const {
		TU8DP_PDDReserved _oDP_PDD_Reserved;
		return _oDP_PDD_Reserved.tGetData();
	};
	virtual tBool bSetPDDReserved(tVoid) {
		TU8DP_PDDReserved _oDP_PDD_Reserved;
		return (DP_S32_NO_ERR == _oDP_PDD_Reserved.s32SetData(u8GetPDDReserved() + 1));
	};
protected:
	TSensor1 m_oSensor1;
	TSensor2 m_oSensor2;
	TSensor3 m_oSensor3;
	TSensor4 m_oSensor4;
	TSensor5 m_oSensor5;
};

#endif /* HC_TCLCFGMGR_PDDTHM_H_ */
