#ifndef _PARKAS_DATAPOOL_H
#define _PARKAS_DATAPOOL_H
// for own datatypes and defines used together with datapool

// NOTE - feature switches are not used as they cannot be applied to datapool generation


//#############################################################################
// KDS coding defines

// AllianceSonarMenuType
enum tenPARKAS_KDS_AllianceSonarMenuType
{
    PARKAS_AllianceSonarMenuType_None         = 0x00,
    PARKAS_AllianceSonarMenuType_Gen3Menu     = 0x01,
    PARKAS_AllianceSonarMenuType_GD1AMenu     = 0x02,
    PARKAS_AllianceSonarMenuType_Gen5Menu     = 0x03
};

// AllianceSonarType
enum tenPARKAS_KDS_AllianceSonarType
{
    PARKAS_AllianceSonarType_None              = 0x00,
    PARKAS_AllianceSonarType_FrontAndRearSonar = 0x01,
    PARKAS_AllianceSonarType_RearSonar         = 0x02
};

// AllianceSonarAVMType
enum tenPARKAS_KDS_AllianceSonarAVMType
{
    PARKAS_AllianceSonarAVMType_AVM      = 0x00, // (AVM (integration into video-signal))
    PARKAS_AllianceSonarAVMType_Headunit = 0x01  // (HeadUnit (drawing an overlay))
};

// AllianceSonarVehicleImageType
enum tenPARKAS_KDS_AllianceSonarVehicleImageType
{
    PARKAS_AllianceSonarVehicleImageType_NoBodyShape = 0x00,
    PARKAS_AllianceSonarVehicleImageType_Sedan       = 0x01,
    PARKAS_AllianceSonarVehicleImageType_SUV         = 0x02,
    PARKAS_AllianceSonarVehicleImageType_Van         = 0x03,
    PARKAS_AllianceSonarVehicleImageType_Coupe       = 0x04,
    PARKAS_AllianceSonarVehicleImageType_42P         = 0x05,
    PARKAS_AllianceSonarVehicleImageType_H_B         = 0x06
};

// AllianceSonarSwitchDisplayType
enum tenPARKAS_KDS_AllianceSonarSwitchDisplayType
{
    PARKAS_AllianceSonarSwitchDisplayType_Off = 0,
    PARKAS_AllianceSonarSwitchDisplayType_On  = 1
};

// AllianceSonarVolumeType
enum tenPARKAS_KDS_AllianceSonarVolumeType
{
    PARKAS_AllianceSonarVolumeType_Minus_3db = 0,
    PARKAS_AllianceSonarVolumeType_Minus_2db = 1,
    PARKAS_AllianceSonarVolumeType_Minus_1db = 2,
    PARKAS_AllianceSonarVolumeType_0db       = 3,
    PARKAS_AllianceSonarVolumeType_1db       = 4,
    PARKAS_AllianceSonarVolumeType_2db       = 5,
    PARKAS_AllianceSonarVolumeType_3db       = 6
};

// AllianceSonarVCANDiversity
enum tenPARKAS_KDS_AllianceSonarVCANDiversity
{
    PARKAS_AllianceSonarVCANDiversity_Default     = 0,
    PARKAS_AllianceSonarVCANDiversity_Slot_1_C1A  = 1,
    PARKAS_AllianceSonarVCANDiversity_Slot_2_C1R  = 2,
    PARKAS_AllianceSonarVCANDiversity_Slot_3_T4vs = 3,
    PARKAS_AllianceSonarVCANDiversity_Slot_4_G1   = 4,
    PARKAS_AllianceSonarVCANDiversity_Slot_5_C1N  = 5,
    PARKAS_AllianceSonarVCANDiversity_Slot_6_gen3 = 6
};

// UPA enums

// UPA Type
enum tenPARKAS_KDS_AllianceUPAType
{
    PARKAS_AllianceUPA_not_present = 0,
    PARKAS_AllianceUPA_Rear        = 1,
    PARKAS_AllianceUPA_Rear_front  = 2
};

// FKP Enabled
enum tenPARKAS_KDS_AllianceFKPEnabled
{
    PARKAS_AllianceFKP_not_configured = 0,
    PARKAS_AllianceFKP_configured     = 1
};

// UPA Audio
enum tenPARKAS_KDS_AllianceUPAAudio
{
    PARKAS_AllianceUPA_audio_not_present      = 0,
    PARKAS_AllianceUPA_audio_without_settings = 1,
    PARKAS_AllianceUPA_audio_with_settings    = 2
};

// User Volume
enum tenPARKAS_KDS_AllianceUPAUserVolume
{
    PARKAS_AllianceUPA_user_volume_OFF              = 0,
    PARKAS_AllianceUPA_user_volume_Very_Low         = 1,
    PARKAS_AllianceUPA_user_volume_Low              = 2,
    PARKAS_AllianceUPA_user_volume_Medium           = 3,
    PARKAS_AllianceUPA_user_volume_High             = 4,
    PARKAS_AllianceUPA_user_volume_Very_High        = 5
};

// u8Vehicle Type (V-CAN Diversity)
enum tenPARKAS_KDS_AllianceUPAVehicleType
{
    PARKAS_AllianceUPA_Vehicle_Type_Default          = 0,
    PARKAS_AllianceUPA_Vehicle_Type_C1A              = 1,
    PARKAS_AllianceUPA_Vehicle_Type_C1R              = 2,
    PARKAS_AllianceUPA_Vehicle_Type_T4vs             = 3,
    PARKAS_AllianceUPA_Vehicle_Type_G1               = 4,
    PARKAS_AllianceUPA_Vehicle_Type_C1N              = 5,
    PARKAS_AllianceUPA_Vehicle_Type_Old_Nissan_or_EV = 6
};

// AVM Enabled
enum tenPARKAS_KDS_AllianceAVMEnabled
{
    PARKAS_AllianceAVM_no_AVM     = 0,
    PARKAS_AllianceAVM_configured = 1
};

// Possible Hfp variants
enum tenPARKAS_KDS_AllianceHFPType
{
    PARKAS_AllianceHFP_Type_None = 0,
    PARKAS_AllianceHFP_Type_HFP,
    PARKAS_AllianceHFP_Type_HFPB,
    PARKAS_AllianceHFP_Type_APK
};

//#############################################################################



// --- Sonar specific defines ---

#define PARKAS_DATA__SONAR_NOT_AVAILABLE       0
#define PARKAS_DATA__SONAR_AVAILABLE           1

enum tenSonarAvailability
{
   EN_SONAR__NONE      =  0,
   EN_SONAR__FR_AND_RR =  1,
   EN_SONAR__RR        =  2
};
enum tenSonarMenu
{
   EN_SONAR_MENU__NONE               = 0,
   EN_SONAR_MENU__GEN3               = 1,
   EN_SONAR_MENU__GD1A               = 2,
   EN_SONAR_MENU__GEN5               = 3
};
enum tenCarShapeModel
{
   EN_CAR_SHAP_MODEL__NOBODYSHAPE =  0,
   EN_CAR_SHAP_MODEL__SEDAN       =  1,
   EN_CAR_SHAP_MODEL__SUV         =  2,
   EN_CAR_SHAP_MODEL__VAN         =  3,
   EN_CAR_SHAP_MODEL__COUPE       =  4,
   EN_CAR_SHAP_MODEL__42P         =  5,
   EN_CAR_SHAP_MODEL__H_B         =  6

};

typedef struct
{
   tenSonarAvailability enSonarAvailability;
   tenSonarMenu         enSonarMenu;
   tBool                bCancelSwitchAvailability;
   tenCarShapeModel     enCarShapeModel;
   tS32                 s32Volume;
}  TSonar_SonarConfiguration;

enum tenSonarModeStatus
{
   EN_SONAR_MODE_STATUS__NO_REQUEST                = 0, // no upa status display request
   EN_SONAR_MODE_STATUS__RR_AND_FR_DEACTIVE        = 1, // Rear and front UPA de-activated
   EN_SONAR_MODE_STATUS__RR_DEACTIVE_AND_FR_ACTIVE = 2, // Rear UPA de-activated and front UPA activated
   EN_SONAR_MODE_STATUS__NOT_USED_1                = 3, // Not used
   EN_SONAR_MODE_STATUS__RR_ACTIVE_AND_FR_DEACTIVE = 4, // Rear UPA activated and front UPA de-activated
   EN_SONAR_MODE_STATUS__NOT_USED_2                = 5, // not used
   EN_SONAR_MODE_STATUS__FR_AND_RR_ACTIVE          = 6, // Rear and front UPA activated
   EN_SONAR_MODE_STATUS__SYSTEM_ERROR              = 7  // System Error
};

enum tenSonarSensitivity
{
   EN_SONAR_SENSITIVITY__FAR      = 1,
   EN_SONAR_SENSITIVITY__MIDDLE   = 2,
   EN_SONAR_SENSITIVITY__NEAR     = 3
};
enum tenSonarVolume
{
   EN_SONAR_VOLUME__LEVEL_1  = 1,
   EN_SONAR_VOLUME__LEVEL_2  = 2,
   EN_SONAR_VOLUME__LEVEL_3  = 3,
   EN_SONAR_VOLUME__LEVEL_4  = 4,
   EN_SONAR_VOLUME__LEVEL_5  = 5,
   EN_SONAR_VOLUME__LEVEL_6  = 6,
   EN_SONAR_VOLUME__LEVEL_7  = 7
};

enum tenSonarVolumeGen3
{
   EN_SONAR_VOLUME__LOW     = 3,
   EN_SONAR_VOLUME__MIDDLE  = 2,
   EN_SONAR_VOLUME__HIGH    = 1
};

enum tenSonarImageDisplayRequest
{
   EN_SONAR_IMAGEDISPLAYREQUEST__NONE                        = 0,
   EN_SONAR_IMAGEDISPLAYREQUEST__REAR_DETECTION_ON           = 1,
   EN_SONAR_IMAGEDISPLAYREQUEST__FRONT_DETECTION_ON          = 2,
   EN_SONAR_IMAGEDISPLAYREQUEST__FRONT_AND_REAR_DETECTION_ON = 3
};

typedef struct
{
   tBool               bSonarSystem;
   tBool               bFrontSensorsOnly;
   tBool               bRearSensorsOnly;
   tBool               bAutomaticDisplay;
   tenSonarSensitivity enSensitivity;
   tenSonarVolume      enVolume;
}  TSonar_SonarSettings;

typedef struct
{
   tBool                       bSonarError;
   tenSonarImageDisplayRequest enDisplayRequest;
}  TSonar_SonarDisplay;

enum tenSensorDetectionRange
{
   EN_SONAR_SENSOR_DTECTION_RANGE__NoDetection = 0,
   EN_SONAR_SENSOR_DTECTION_RANGE__Level1      = 1,
   EN_SONAR_SENSOR_DTECTION_RANGE__Level2      = 2,
   EN_SONAR_SENSOR_DTECTION_RANGE__Level3      = 3,
   EN_SONAR_SENSOR_DTECTION_RANGE__Level4      = 4
};
typedef struct
{
   tBool                     bSensorAvailable_CornerLeft;
   tenSensorDetectionRange   enSensorDetectionRangeStatus_CornerLeft;
   tBool                     bSensorAvailable_Center;
   tenSensorDetectionRange   enSensorDetectionRangeStatus_Center;
   tBool                     bSensorAvailable_CornerRight;
   tenSensorDetectionRange   enSensorDetectionRangeStatus_CornerRight;
}  TSonar_SonarSensors;

enum tenSensorSettingsChangeRequest
{
   EN_SONAR_SETTINGS_CHANGE_REQUEST__NoRequest           =  0,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__SonarSystemPauseOff =  1,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__SonarSystemPauseOn  =  2,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__SonarSystemOff      =  3,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__SonarSystemOn       =  4,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__FrontSensorsOnlyOff =  5,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__FrontSensorsOnlyOn  =  6,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__RearSensorsOnlyOff  =  7,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__RearSensorsOnlyOn   =  8,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__AutomaticDisplayOff =  9,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__AutomaticDisplayOn  = 10,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__SensitivityFar      = 11,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__SensitivityMid      = 12,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__SensitivityNear     = 13,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__VolumeHigh          = 14,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__VolumeMiddle        = 15,
   EN_SONAR_SETTINGS_CHANGE_REQUEST__VolumeLow           = 16
};

// Note - ideally these definitions would be controlled by the Feature switch, 
// however they are needed by the automatically generated datapool files
// UPA Specific

enum tenSensorSettingsUPA_Type
{
   EN_UPA_TYPE_NOT_PRESENT    = 0,
   EN_UPA_TYPE_REAR_ONLY      = 1,
   EN_UPA_TYPE_FRONT_AND_REAR = 2
};

enum tenSensorSettingsUPA_AudioType
{
   EN_UPA_AUDIO_TYPE_NOT_PRESENT      = 0,
   EN_UPA_AUDIO_TYPE_WITHOUT_SETTINGS = 1,
   EN_UPA_AUDIO_TYPE_WITH_SETTINGS    = 2
};

enum tenSensorSettingsUPA_UserVolume
{
   EN_UPA_USER_VOLUME_TYPE_OFF       = 0,
   EN_UPA_USER_VOLUME_TYPE_VERY_LOW  = 1,
   EN_UPA_USER_VOLUME_TYPE_LOW       = 2,
   EN_UPA_USER_VOLUME_TYPE_MEDIUM    = 3,
   EN_UPA_USER_VOLUME_TYPE_HIGH      = 4,
   EN_UPA_USER_VOLUME_TYPE_VERY_HIGH = 5
};

enum tenSensorSettingsUPA_VehicleType
{
   EN_UPA_USER_VEHICLE_TYPE_NONE = 0,
   EN_UPA_USER_VEHICLE_TYPE_C1A  = 1,
   EN_UPA_USER_VEHICLE_TYPE_T4VS = 2
};

enum tenSensorSettingsUPA_SystemState
{
   EN_UPA_USER_SYSTEM_STATE_TYPE_OPERATIONAL_MODE = 0,
   EN_UPA_USER_SYSTEM_STATE_TYPE_NORMAL_MODE      = 1,
   EN_UPA_USER_SYSTEM_STATE_TYPE_STANDBY_MODE     = 2,
   EN_UPA_USER_SYSTEM_STATE_TYPE_ERROR_MODE       = 3
};

enum tenSensorSettingsUPA_ImageDisplayRequest
{
   EN_UPA_USER_IMAGE_DISPLAY_REQUEST_TYPE_NO_DISPLAY_REQUEST          = 0,
   EN_UPA_USER_IMAGE_DISPLAY_REQUEST_TYPE_INACTIVE                    = 1,
   EN_UPA_USER_IMAGE_DISPLAY_REQUEST_TYPE_USUAL_MODE                  = 2,
   EN_UPA_USER_IMAGE_DISPLAY_REQUEST_TYPE_REAR_DETECTION_ON           = 3,
   EN_UPA_USER_IMAGE_DISPLAY_REQUEST_TYPE_FRONT_DETECTION_ON          = 4,
   EN_UPA_USER_IMAGE_DISPLAY_REQUEST_TYPE_FRONT_AND_REAR_DETECTION_ON = 5
};

enum tenSensorSettingsUPA_ObstacleZone
{
   EN_UPA_OBSTACLE_ZONE_TYPE_NO_DETECTION               =  0,
   EN_UPA_OBSTACLE_ZONE_TYPE_NO_DISPLAY_REQUEST         =  1,
   EN_UPA_OBSTACLE_ZONE_TYPE_RESERVE                    =  2,
   EN_UPA_OBSTACLE_ZONE_TYPE_UNAVAILABLE                =  3,
   EN_UPA_OBSTACLE_ZONE_TYPE_DETECT_LEVEL_2             =  4,
   EN_UPA_OBSTACLE_ZONE_TYPE_DETECT_LEVEL_3             =  5,
   EN_UPA_OBSTACLE_ZONE_TYPE_DETECT_LEVEL_4             =  6,
   EN_UPA_OBSTACLE_ZONE_TYPE_REAR_ZONE_1                =  7,
   EN_UPA_OBSTACLE_ZONE_TYPE_REAR_ZONE_2                =  8,
   EN_UPA_OBSTACLE_ZONE_TYPE_REAR_ZONE_3                =  9,
   EN_UPA_OBSTACLE_ZONE_TYPE_REAR_ZONE_4                = 10,
   EN_UPA_OBSTACLE_ZONE_TYPE_LATERAL_ZONE_1             = 11,
   EN_UPA_OBSTACLE_ZONE_TYPE_LATERAL_ZONE_2             = 12,
   EN_UPA_OBSTACLE_ZONE_TYPE_LATERAL_ZONE_3             = 13,
   EN_UPA_OBSTACLE_ZONE_TYPE_LATERAL_USUAL              = 14,
   EN_UPA_OBSTACLE_ZONE_TYPE_NOT_USED                   = 15
};

enum tenSensorSettingsUPA_ObstacleZoneCenter
{
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_NO_DETECTION        =  0,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_NO_DISPLAY_REQUEST  =  1,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_RESERVE             =  2,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_UNAVAILABLE         =  3,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_DETECT_LEVEL_1      =  4,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_DETECT_LEVEL_2      =  5,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_DETECT_LEVEL_3      =  6,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_DETECT_LEVEL_4      =  7,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_REAR_ZONE_1         =  8,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_REAR_ZONE_2         =  9,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_REAR_ZONE_3         = 10,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_REAR_ZONE_4         = 11,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_LATERAL_ZONE_1      = 12,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_LATERAL_ZONE_2      = 13,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_LATERAL_ZONE_3      = 14,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_LATERAL_USUAL       = 15,
   EN_UPA_OBSTACLE_ZONE_CENTER_TYPE_NOT_USED            = 16
};

enum tenSensorSettingsUPA_FKPObstacleZone
{
   EN_UPA_FKP_OBSTACLE_ZONE_TYPE_NO_DETECTION           = 0,
   EN_UPA_FKP_OBSTACLE_ZONE_DETECTED_LEVEL_1            = 1,
   EN_UPA_FKP_OBSTACLE_ZONE_DETECTED_LEVEL_2            = 2,
   EN_UPA_FKP_OBSTACLE_ZONE_DETECTED_LEVEL_3            = 3
};

enum tenSensorSettingsFKP_Image_Display_Request
{
   EN_UPA_FKP_IMAGE_DISPLAY_NOT_REQUESTED               = 0,
   EN_UPA_FKP_IMAGE_DISPLAY_REQUESTED                   = 1
};

enum tenSensorSettingsUPA_Closing_Authorization
{
   EN_UPA_CLOSING_AUTHORIZATION_NOT_AUTHORIZED          = 0,
   EN_UPA_CLOSING_AUTHORIZATION_AUTHORIZED              = 1
};

enum tenSensorSettingsUPA_UPA_System
{
   EN_UPA_UPA_SYSTEM_OFF                                = 0,
   EN_UPA_UPA_SYSTEM_ON                                 = 1
};

enum tenSensorSettingsUPA_UPA_Automatic_Display
{
   EN_UPA_AUTOMATIC_DISPLAY_OFF                         = 0,
   EN_UPA_AUTOMATIC_DISPLAY_ON                          = 1
};

enum tenSensorSettingsUPA_UPA_Error
{
   EN_UPA_NO_ERROR                                      = 0,
   EN_UPA_ERROR                                         = 1
};

enum tenSensorSettingsUPA_Rear_Park_Assist_State
{
   EN_UPA_REAR_PARK_ASSIST_STATE_OFF                    = 0,
   EN_UPA_REAR_PARK_ASSIST_STATE_ON                     = 1
};

enum tenSensorSettingsUPA_Front_Park_Assist_State
{
   EN_UPA_FRONT_PARK_ASSIST_STATE_OFF                   = 0,
   EN_UPA_FRONT_PARK_ASSIST_STATE_ON                    = 1
};

enum tenSensorSettingsFKP_Activation_Status
{
   EN_UPA_FKP_ACTIVATION_STATUS_OFF                     = 0,
   EN_UPA_FKP_ACTIVATION_STATUS_ON                      = 1
};

enum tenSensorSettingsSonarSystemPause_Status
{
   EN_UPA_SONARSYSTEMPAUSE_STATUS_OFF                    = 0,
   EN_UPA_SONARSYSTEMPAUSE_STATUS_ON                     = 1
};

enum tenSensorSettingsUPA_Hatch
{
   EN_UPA_HATCH_OFF                                     = 0,
   EN_UPA_HATCH_ON                                      = 1
};

enum tenSensorSettingsFKP_Scan
{
   EN_UPA_FKP_SCAN_OFF                                  = 0,
   EN_UPA_FKP_SCAN_ON                                   = 1
};

enum tenSensorSettingsFKP_Hatch
{
   EN_UPA_FKP_HATCH_OFF                                 = 0,
   EN_UPA_FKP_HATCH_ON                                  = 1
};

enum tenUPASettingsChangeRequest
{
   EN_UPA_SETTINGS_CHANGE_REQUEST__NoChangeRequest      = 0
};

typedef struct
{
   tenSensorSettingsUPA_Type         enUPAType;
   tBool                             bFKPEnabled;
   tenSensorSettingsUPA_AudioType    enUPAAudio;
   tU8                               u8AudioMute;
   tU8                               u8AudioGain;
   tenSensorSettingsUPA_UserVolume   enUserVolume;
   tenSensorSettingsUPA_VehicleType  enVehicleType;
   tBool                             bAVMEnabled;
   tenCarShapeModel                  enVehicleShape;
}  TUPA_UPAConfig;

typedef struct
{
   tenSensorSettingsUPA_ImageDisplayRequest  enUPAImageDisplayRequest;
   tBool                                     bFKPImageDisplayRequest;
   tenSensorSettingsUPA_SystemState          enUPASystemState;
   tBool                                     bClosingAuthorization;
   tBool                                     bUPASystem;
   tBool                                     bUPAAutomaticDisplay;
   tBool                                     bUPAError;
   tBool                                     bRearParkAssistState;
   tBool                                     bFrontParkAssistState;
   tBool                                     bFKPActivationStatus;
   tBool                                     bSonarSystemPauseStatus;
}  TUPA_UPAStatus;

typedef struct
{
   tenSensorSettingsUPA_ObstacleZone        enObstacleZoneRearLeft;
   tenSensorSettingsUPA_ObstacleZoneCenter  enObstacleZoneRearCenter;
   tenSensorSettingsUPA_ObstacleZone        enObstacleZoneRearRight;
   tenSensorSettingsUPA_ObstacleZone        enObstacleFrontLeft;
   tenSensorSettingsUPA_ObstacleZoneCenter  enObstacleFrontCenter;
   tenSensorSettingsUPA_ObstacleZone        enObstacleFrontRight;
}  TUPA_UPASensors;

typedef struct
{
   tBool                     bFrontLeftHatch;
   tBool                     bFrontMiddleHatch;
   tBool                     bFrontRightHatch;
   tBool                     bRearLeftHatch;
   tBool                     bRearMiddleHatch;
   tBool                     bRearRightHatch;
}  TUPA_UPAHatch;

typedef struct
{
   tenSensorSettingsUPA_FKPObstacleZone  enObstacleZoneLF;
   tenSensorSettingsUPA_FKPObstacleZone  enObstacleZoneLFC;
   tenSensorSettingsUPA_FKPObstacleZone  enObstacleZoneLRC;
   tenSensorSettingsUPA_FKPObstacleZone  enObstacleZoneLR;
   tenSensorSettingsUPA_FKPObstacleZone  enObstacleZoneRF;
   tenSensorSettingsUPA_FKPObstacleZone  enObstacleZoneRFC;
   tenSensorSettingsUPA_FKPObstacleZone  enObstacleZoneRRC;
   tenSensorSettingsUPA_FKPObstacleZone  enObstacleZoneRR;
}  TUPA_UPAFKPSensors;

typedef struct
{
   tBool                     bFrontFrontLScan;
   tBool                     bFrontMiddleLScan;
   tBool                     bRearMiddleLScan;
   tBool                     bRearRearLScan;
   tBool                     bFrontFrontRScan;
   tBool                     bFrontMiddleRScan;
   tBool                     bRearMiddleRScan;
   tBool                     bRearRearRScan;
}  TUPA_UPAFKPScan;

typedef struct
{
   tBool                     bFrontFrontLHatch;
   tBool                     bFrontMiddleLHatch;
   tBool                     bRearMiddleLHatch;
   tBool                     bRearRearLHatch;
   tBool                     bFrontFrontRHatch;
   tBool                     bFrontMiddleRHatch;
   tBool                     bRearMiddleRHatch;
   tBool                     bRearRearRHatch;
}  TUPA_UPAFKPHatch;

enum tenSensorSettingsChangeRequest_UPA
{
   EN_UPA_SETTINGS_CHANGE_REQUEST__NoRequest           =  0,
   EN_UPA_SETTINGS_CHANGE_REQUEST__UPASystemPauseOff   =  1,
   EN_UPA_SETTINGS_CHANGE_REQUEST__UPASystemPauseOn    =  2,
   EN_UPA_SETTINGS_CHANGE_REQUEST__UPASystemOff        =  3,
   EN_UPA_SETTINGS_CHANGE_REQUEST__UPASystemOn         =  4,
   EN_UPA_SETTINGS_CHANGE_REQUEST__FrontSensorsOnlyOff =  5,
   EN_UPA_SETTINGS_CHANGE_REQUEST__FrontSensorsOnlyOn  =  6,
   EN_UPA_SETTINGS_CHANGE_REQUEST__RearSensorsOnlyOff  =  7,
   EN_UPA_SETTINGS_CHANGE_REQUEST__RearSensorsOnlyOn   =  8,
   EN_UPA_SETTINGS_CHANGE_REQUEST__FKPSensorsOff       =  9,
   EN_UPA_SETTINGS_CHANGE_REQUEST__FKPSensorsOn        = 10,
   EN_UPA_SETTINGS_CHANGE_REQUEST__AutomaticDisplayOff = 11,
   EN_UPA_SETTINGS_CHANGE_REQUEST__AutomaticDisplayOn  = 12,
   EN_UPA_SETTINGS_CHANGE_REQUEST__UPA_FKP_Reset       = 13,
   EN_UPA_SETTINGS_CHANGE_REQUEST__UPA_Detailed_Request = 14
};

enum tenSensorSettingsUPA_SonarSystemPauseRequest2
{
   EN_UPA_SONARSYSTEMPAUSEREQUEST2_NO_REQUEST             = 0,
   EN_UPA_SONARSYSTEMPAUSEREQUEST2_SYSTEM_PAUSE_REQUESTED = 1
};

enum tenSensorSettingsUPA_RearParkAssistActivationReq2
{
   EN_UPA_REARPARKASSISTACTIVATIONREQ2_NO_REQUEST            = 0,
   EN_UPA_REARPARKASSISTACTIVATIONREQ2_ACTIVATION_REQUEST    = 1,
   EN_UPA_REARPARKASSISTACTIVATIONREQ2_DE_ACTIVATION_REQUEST = 2,
   EN_UPA_REARPARKASSISTACTIVATIONREQ2_RESET_REQUEST         = 3
};

enum tenSensorSettingsUPA_FrontParkAssistActivationReq2
{
   EN_UPA_FRONTPARKASSISTACTIVATIONREQ2_NO_REQUEST            = 0,
   EN_UPA_FRONTPARKASSISTACTIVATIONREQ2_ACTIVATION_REQUEST    = 1,
   EN_UPA_FRONTPARKASSISTACTIVATIONREQ2_DE_ACTIVATION_REQUEST = 2,
   EN_UPA_FRONTPARKASSISTACTIVATIONREQ2_RESET_REQUEST         = 3
};

enum tenSensorSettingsUPA_FKP_ActivationRequest2
{
   EN_UPA_FKP_ACTIVATIONREQUEST2_NO_REQUEST    = 0,
   EN_UPA_FKP_ACTIVATIONREQUEST2_NOT_REQUESTED = 1,
   EN_UPA_FKP_ACTIVATIONREQUEST2_REQUESTED     = 2,
   EN_UPA_FKP_ACTIVATIONREQUEST2_RESET_REQUEST = 3
};

//HFP related defines

enum tenHfpMapContent
{
   EN_HFP_MAP_CONTENT_EMPTY_DISPLAY                    = 0,
   EN_HFP_MAP_CONTENT_SCANNING_DISPLAY                 = 1,
   EN_HFP_MAP_CONTENT_PARKOUT_CONFIRMATION_DISPLAY     = 2,
   EN_HFP_MAP_CONTENT_PARKIN_GUIDANCE_DISPLAY          = 3,
   EN_HFP_MAP_CONTENT_UNAVAILABLE                      = 7
};

enum tenHfpScanningSide
{
   EN_HFP_SCANNING_SIDE_NONE                           = 0,
   EN_HFP_SCANNING_SIDE_LEFT                           = 1,
   EN_HFP_SCANNING_SIDE_RIGHT                          = 2,
   EN_HFP_SCANNING_SIDE_UNAVAILABLE                    = 3
};

enum tenHfpInfoContent
{
   EN_HFP_INFO_CONTENT_ERROR_DISPLAY                   = 0,
   EN_HFP_INFO_CONTENT_SLOTSEARCH_DISPLAY              = 1,
   EN_HFP_INFO_CONTENT_PARKOUT_DISPLAY                 = 2,
   EN_HFP_INFO_CONTENT_AUTOMATIC_MANEUVER_DISPLAY      = 3,
   EN_HFP_INFO_CONTENT_MANEUVER_FINISHED_DISPLAY       = 4,
   EN_HFP_INFO_CONTENT_UNAVAILABLE                     = 7
};

enum tenHfpManeuverType
{
   EN_HFP_MANEUVER_TYPE_UNAVAILABLE                    = 0,
   EN_HFP_MANEUVER_TYPE_PARKIN_PARALLEL                = 1,
   EN_HFP_MANEUVER_TYPE_PARKIN_PERPEND                 = 2,
   EN_HFP_MANEUVER_TYPE_PARKIN_ANGLED                  = 3,
   EN_HFP_MANEUVER_TYPE_PARKOUT                        = 4
};

enum tenHfpManeuverMove
{
   EN_HFP_MANEUVER_UNAVAILABLE                         = 0,
   EN_HFP_MANEUVER_MOVE_FIRST_MOVE                     = 1,
   EN_HFP_MANEUVER_MOVE_BACKWARD_MOVE                  = 2,
   EN_HFP_MANEUVER_MOVE_FORWARD_MOVE                   = 3
};

enum tenHfpSoundRequest
{
   EN_HFP_SOUND_REQUEST_NONE                           = 0,
   EN_HFP_SOUND_REQUEST_LEVEL_1                        = 1,
   EN_HFP_SOUND_REQUEST_LEVEL_2                        = 2,
   EN_HFP_SOUND_REQUEST_UNAVAILABLE                    = 3
};

enum tenHfpSlotSuitable
{
   EN_HFP_SLOT_SUITABLE_UNAVAILABLE                    = 0,
   EN_HFP_SLOT_SUITABLE_AVAILABLE                      = 1
};

enum tenHfpSlotSelection
{
   EN_HFP_SLOT_NOT_SELECTED                            = 0,
   EN_HFP_SLOT_SELECTED                                = 1
};

enum tenHfpUserFeedbackAvailability
{
   EN_HFP_USER_FEEDBACK_AVAILABLE                      = 0,
   EN_HFP_USER_FEEDBACK_UNAVAILABLE                    = 1
};

enum tenHfpAudioAvailability
{
   EN_HFP_AUDIO_AVAILABLE                              = 0,
   EN_HFP_AUDIO_UNAVAILABLE                            = 1
};

enum tenHfpUserAcknowledgment
{
   EN_HFP_NO_USER_ACKNOWLEDGMENT                       = 0,
   EN_HFP_USER_ACKNOWLEDGMENT                          = 1
};

enum tenHfpCDisplayAvailability
{
   EN_HFP_CDISPLAY_UNAVAILABLE                         = 0,
   EN_HFP_CDISPLAY_AVAILABLE                           = 1,
   EN_HFP_CDISPLAY_NOT_AVAILABLE                       = 2
};

enum tenHfpManeuverTypeRequest
{
   EN_HFP_MANEUVER_TYPE_REQUEST_NONE                   = 0,
   EN_HFP_MANEUVER_TYPE_REQUEST_PARKIN_PARALLEL        = 1,
   EN_HFP_MANEUVER_TYPE_REQUEST_PARKIN_PERPEND         = 2,
   EN_HFP_MANEUVER_TYPE_REQUEST_PARKIN_ANGLED          = 3,
   EN_HFP_MANEUVER_TYPE_REQUEST_PARKOUT                = 4,
   EN_HFP_MANEUVER_TYPE_REQUEST_RESET                  = 7
};


#endif //_PARKAS_DATAPOOL_H
