/*
 * cfgmgr_DltWrapper.cpp
 *
 *  Created on: Sep 06, 2017
 *      Author: ogm5kor
 */
 
#ifndef CFGMGR_DLTWRAPPER_H_
#include "cfgmgr_DltWrapper.h"
#endif

#include <string>
#include <sstream>
#include <iostream>
#include <string.h>

using namespace std;
namespace cfmg
{

cfgmgr_DltWrapper* cfgmgr_DltWrapper::mpDLTWrapper = NULL;
pthread_mutex_t cfgmgr_DltWrapper::mMutex = PTHREAD_MUTEX_INITIALIZER;

cfgmgr_DltWrapper *cfgmgr_DltWrapper::instance(const bool enableNoDLTDebug)
{
    if (!mpDLTWrapper)
        mpDLTWrapper = new cfgmgr_DltWrapper(enableNoDLTDebug);
#ifndef WITH_DLT
    if(enableNoDLTDebug)
        mpDLTWrapper->enableNoDLTDebug(true);
#endif
    return (mpDLTWrapper);
}

void cfgmgr_DltWrapper::unregisterContext(DltContext & handle)
{
#ifdef WITH_DLT
    dlt_unregister_context(&handle);
#else
    (void) handle;
#endif
}

void cfgmgr_DltWrapper::deinit()
{
#ifdef WITH_DLT
    unregisterContext(mDltContext);
#endif
}

cfgmgr_DltWrapper::cfgmgr_DltWrapper(const bool enableNoDLTDebug) :
#ifndef WITH_DLT
        mEnableNoDLTDebug(enableNoDLTDebug),
#endif
        mDltContext(), //
        mDltContextData()
{
    (void) enableNoDLTDebug;
#ifndef WITH_DLT
    std::cout << "\e[0;34m[DLT]\e[0;30m\tRunning without DLT-support" << std::endl;
#endif
}

void cfgmgr_DltWrapper::registerApp(const char *appid, const char *description)
{
#ifdef WITH_DLT
    dlt_register_app(appid, description);
#else
    (void) appid;
    (void) description;
#endif
}

void cfgmgr_DltWrapper::registerContext(DltContext& handle, const char *contextid, const char *description)
{
#ifdef WITH_DLT
    dlt_register_context(&handle, contextid, description);
#else
    strncpy(handle.contextID,contextid,4);

    // store only the first contextID
    if(0 == strlen(mDltContext.contextID))
    {
        memcpy(&mDltContext.contextID,contextid,4);
        const size_t str_len = strlen(description);
        if(2000 > str_len)
        {
            mDltContextData.context_description = new char[1 + str_len];
            (void) strcpy(mDltContextData.context_description,description);
        }
        mDltContext.log_level_user = DLT_DEFAULT_LOG_LEVEL;
    }
    handle.log_level_user = DLT_DEFAULT_LOG_LEVEL;
    std::cout << "\e[0;34m[DLT]\e[0;30m\tRegistering Context " << contextid << " , " << description << std::endl;

#endif
}

void cfgmgr_DltWrapper::registerContext(DltContext& handle, const char *contextid, const char * description,
        const DltLogLevelType level, const DltTraceStatusType status)
{
#ifdef WITH_DLT
    dlt_register_context_ll_ts(&handle, contextid, description, level, status);
#else
    strncpy(handle.contextID,contextid,4);

    // store only the first contextID
    if(0 == strlen(mDltContext.contextID))
    {
        memcpy(&mDltContext.contextID,contextid,4);
        const size_t str_len = strlen(description);
        if(2000 > str_len)
        {
            mDltContextData.context_description = new char[1 + str_len];
            (void) strcpy(mDltContextData.context_description,description);
        }
        mDltContext.log_level_user = level;
    }
    handle.log_level_user = level;
    std::cout << "\e[0;34m[DLT]\e[0;30m\tRegistering Context " << contextid << " , " << description << std::endl;

#endif
}

bool cfgmgr_DltWrapper::init(DltLogLevelType loglevel, DltContext* context)
{
    (void) loglevel;

    pthread_mutex_lock(&mMutex);
    if (!context)
        context = &mDltContext;

#ifdef WITH_DLT
    if (0 >= dlt_user_log_write_start(context, &mDltContextData, loglevel))
#else
    if((mEnableNoDLTDebug == false) || (loglevel > context->log_level_user))
#endif
    {
         pthread_mutex_unlock(&mMutex);
        return false;
    }
#ifndef WITH_DLT
    std::cout << "\e[0;34m[" << context->contextID << "]\e[0;30m\t";
#endif
    return true;
}

void cfgmgr_DltWrapper::send()
{
#ifdef WITH_DLT
    dlt_user_log_write_finish(&mDltContextData);
#else
    if(mEnableNoDLTDebug)
        std::cout << mDltContextData.buffer.str() << std::endl;
	
    mDltContextData.buffer.str("");
    mDltContextData.buffer.clear();
#endif
    pthread_mutex_unlock(&mMutex);
}

void cfgmgr_DltWrapper::append(const int8_t value)
{
#ifdef WITH_DLT
    dlt_user_log_write_int8(&mDltContextData, value);
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const uint8_t value)
{
#ifdef WITH_DLT
    dlt_user_log_write_uint8(&mDltContextData, value);
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const int16_t value)
{
#ifdef WITH_DLT
    dlt_user_log_write_int16(&mDltContextData, value);
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const uint16_t value)
{
#ifdef WITH_DLT
    dlt_user_log_write_uint16(&mDltContextData, value);
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const int32_t value)
{
#ifdef WITH_DLT
    dlt_user_log_write_int32(&mDltContextData, value);
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const uint32_t value)
{
#ifdef WITH_DLT
    dlt_user_log_write_uint32(&mDltContextData, value);
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const char* value)
{
#ifdef WITH_DLT
    dlt_user_log_write_string(&mDltContextData, value);
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const std::string& value)
{
#ifdef WITH_DLT
    dlt_user_log_write_string(&mDltContextData, value.c_str());
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const bool value)
{
#ifdef WITH_DLT
    dlt_user_log_write_bool(&mDltContextData, static_cast<uint8_t>(value));
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const int64_t value)
{
#ifdef WITH_DLT
    dlt_user_log_write_int64(&mDltContextData, value);
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const uint64_t value)
{
#ifdef WITH_DLT
    dlt_user_log_write_uint64(&mDltContextData, value);
#else
    appendNoDLT(value);
#endif
}

void cfgmgr_DltWrapper::append(const std::vector<uint8_t> & data)
{
#ifdef WITH_DLT
  dlt_user_log_write_raw(&mDltContextData,(void*)data.data(),data.size());
#else
  mDltContextData.buffer << data.data();
#endif
}

#ifndef WITH_DLT
template<class T> void cfgmgr_DltWrapper::appendNoDLT(T value)
{
    mDltContextData.buffer << value;
}

void cfgmgr_DltWrapper::enableNoDLTDebug(const bool enableNoDLTDebug)
{
    mEnableNoDLTDebug = enableNoDLTDebug;
}
#endif

cfgmgr_DltWrapper::~cfgmgr_DltWrapper()
{
    if (mpDLTWrapper)
    {
        mpDLTWrapper->unregisterContext(mDltContext);
        delete mpDLTWrapper;
    }
}
}

