/**
 * @file   : cfgmgr_IUpdateManager.h
 * @author : ogm5kor
 * @date   : Sep 21, 2017
 * @brief  : Interface file for UpdateManager with pure virtual functions
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifndef CFGMGR_IUPDATEMANAGER_H_
#define CFGMGR_IUPDATEMANAGER_H_

#ifndef CFGMGR_TYPES_H
#include "../asf/cfgmgr_Types.h"
#endif

#ifndef CFGMGR_IRESPONSE_LISTENER_H_
#include "cfgmgr_IResponseListener.h"
#endif

class cfgmgr_IUpdateManager {
public:
	cfgmgr_IUpdateManager() {}
	virtual ~cfgmgr_IUpdateManager() {}

	//--------------------------------------------------------------------------
	// Handling of Registrations Requests from Components
	//--------------------------------------------------------------------------

	virtual Reg_Status_T registerPrivateConfigItem(ClientData_T& clientData) = 0;

	virtual Reg_Status_T unregisterPrivateConfigItem(tStr itemName, tStr dbusName) = 0;

	virtual Reg_Status_T registerPublicConfigItem(ClientData_T& clientData) = 0;

	virtual Reg_Status_T unregisterPublicConfigItem(tStr itemName, tStr dbusName) = 0;

	//--------------------------------------------------------------------------
	// Handling of Data Requests from FOTA
	//--------------------------------------------------------------------------

	//Send Private and Public Data from FOTA
	virtual tVoid SendData(map<tStr,tStr> configData, DescmoState_T configItem, tbool isCfgMgrRegistered, tStr actionType) =  0;

    //Send XML Data
	virtual tVoid SendDataXml(DescmoState_T configItem) =  0;

	//--------------------------------------------------------------------------
	// Handling of Data Requests from Components
	//--------------------------------------------------------------------------

    //Send the Public/Local Data from HMI
	virtual Cfgmgr_ItemStatus_T SendDataPublic(map<tStr,tStr> configData, tStr configItemName) = 0;

    //Get the Public/Local Data
	virtual Cfgmgr_ItemStatus_T getPublicData(tStr configItemName, ConfigItem_T& itemList) = 0; // To get the public data from datapool

//	//--------------------------------------------------------------------------
//	// Handling of Response received from Apps
//	//--------------------------------------------------------------------------
//
//	tVoid onSetPrivateItem(Cfgmgr_ItemStatus_T result );
//
//	tVoid onGetPrivateItem(Cfgmgr_ItemStatus_T result, ConfigItem_T data);
//
//	tVoid onExchangeDESCMO(Cfgmgr_ItemStatus_T result, tStr xmlData);

	//--------------------------------------------------------------------------
	// Other Local Methods
	//--------------------------------------------------------------------------

//	tVoid registerClientHandler(cfgmgr_INAClientHandler* pHandler);

	virtual tVoid setListener(cfgmgr_IResponseListener *pListener) = 0;

	virtual tVoid unsetListener() = 0;

	//Get the Client details from Proxy database
	virtual bool checkForConfigItemSubscribed(tStr profileName, FormatIdentifier &formatId,tbool &isCfgMgrRegistered) = 0;

//		tVoid SendDefaultPrivateData(ConfigItem_T configDataList,stCustomSetData customData,tStr profileName);
//	tVoid SendDefaultPublicData(ConfigItem_T configDataList,stCustomSetData customData,tStr profileName);


};

#endif /* CFGMGR_IUPDATEMANAGER_H_ */
