/**
 * @file   : cfgmgr_IResponseListener.h
 * @author : nce5kor
 * @date   : Aug 24, 2017
 * @brief  : Interface listener file to handle responses
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifndef CFGMGR_IRESPONSE_LISTENER_H_
#define CFGMGR_IRESPONSE_LISTENER_H_

#ifndef CFGMGR_TYPES_H
#include "../asf/cfgmgr_Types.h"
#endif


class cfgmgr_IResponseListenerImpl
{
public:
	cfgmgr_IResponseListenerImpl() {}
	~cfgmgr_IResponseListenerImpl() {}

	virtual tVoid onDefaultDataResponse (vector<ConfigData_T> configData, Cfgmgr_ItemStatus_T status, DescmoState_T& configItem, tStr actionType) = 0;

	virtual tVoid onXmlDataResponse (tStr xmlData,Cfgmgr_ItemStatus_T status, DescmoState_T& configItem) = 0;

};

class cfgmgr_IResponseListener:public cfgmgr_IResponseListenerImpl
{
public:
	cfgmgr_IResponseListener() {}
	~cfgmgr_IResponseListener() {}

	virtual tVoid onDefaultDataResponse (vector<ConfigData_T> configData, Cfgmgr_ItemStatus_T status, DescmoState_T& configItem, tStr actionType){ }

	virtual tVoid onXmlDataResponse (tStr xmlData,Cfgmgr_ItemStatus_T status, DescmoState_T& configItem){ }

};

#endif
