/**
 * @file   : cfgmgr_RegistrationRequestHandler.h
 * @author : nce5kor
 * @date   : Aug 24, 2017
 * @brief  : To handle data for registration requests from applications
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
 
#ifndef cfgmgr_RegistartionRequestHandler_H_
#define cfgmgr_RegistartionRequestHandler_H_

#ifndef __UNITTEST_CFGMGR__

#ifndef CFGMGR_CLIENTDATABASE_H_
#include "cfgmgr_ClientDatabase.h"
#endif

#ifndef cfgmgr_UpdateManager_H_
#include "cfgmgr_UpdateManager.h"
#endif
#endif

#ifndef CFGMGR_DLTWRAPPER_H_
#include "../trace/cfgmgr_DltWrapper.h"
#endif
#ifdef __UNITTEST_CFGMGR__
#include "../../../utest/mocks/cfgmgr_MockUpdateManager.h"
#endif
class cfgmgr_RegistrationRequestHandler
{
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(cfgmgr_RegistrationRequestHandler);
public:
	cfgmgr_RegistrationRequestHandler();
	~cfgmgr_RegistrationRequestHandler();

	static cfgmgr_RegistrationRequestHandler* getInstanceofRegistrationRequestHandler();

	Reg_Status_T registerConfigItem(ClientData_T& clientData);

	Reg_Status_T unregisterConfigItem(ClientData_T clientData);

	#ifdef __UNITTEST_CFGMGR__
		void reg_IUpdateManager(cfgmgr_IUpdateManager* um_IPtr)
		{
			m_pUpdateManager = um_IPtr;
		}
	#endif
private:

	static cfgmgr_RegistrationRequestHandler* pRequestHandler;

	#ifndef __UNITTEST_CFGMGR__
 	cfgmgr_UpdateManager* m_pUpdateManager;

 	cfgmgr_UpdateManager* getInstanceOfUpdateManager();
	#else
		cfgmgr_IUpdateManager* m_pUpdateManager;
	#endif

};

#endif
