/**
 * @file   : cfgmgr_LocalDataHandler
 * @author : nce5kor
 * @date   : Aug 24, 2017
 * @brief  : To handle data for local item set/get from applications
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
#ifndef CFGMGR_LOCALDATAHANDLER_H_
#define CFGMGR_LOCALDATAHANDLER_H_

#ifndef CFGMGR_DLTWRAPPER_H_
#include "../trace/cfgmgr_DltWrapper.h"
#endif

#ifndef __UNITTEST_CFGMGR__
#ifndef cfgmgr_UpdateManager_H_
#include "cfgmgr_UpdateManager.h"
#endif
#endif
#ifdef __UNITTEST_CFGMGR__
#include "../../../utest/mocks/cfgmgr_MockUpdateManager.h"
#endif

using namespace cfmg;

class cfgmgr_LocalDataHandler
{
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(cfgmgr_LocalDataHandler);
public:
	cfgmgr_LocalDataHandler();
	~cfgmgr_LocalDataHandler();

	static cfgmgr_LocalDataHandler* getInstanceofLocalDataHandler();

    //Send the Public/Local Data from HMI
	Cfgmgr_ItemStatus_T SendDataPublic(map<tStr,tStr> configData, tStr configItemName);

    //Get the Public/Local Data
	Cfgmgr_ItemStatus_T getPublicData(tStr configItemName, ConfigItem_T& itemList); // To get the publci data from datapool

	#ifdef __UNITTEST_CFGMGR__
		void reg_IUpdateManager(cfgmgr_IUpdateManager* um_IPtr)
		{
			m_pUpdateManager = um_IPtr;
		}
	#endif
private:

	static cfgmgr_LocalDataHandler* pLocalDataHandler;

	#ifndef __UNITTEST_CFGMGR__
 	cfgmgr_UpdateManager* m_pUpdateManager;

 	cfgmgr_UpdateManager* getInstanceOfUpdateManager();
	#else
		cfgmgr_IUpdateManager* m_pUpdateManager;
	#endif

};

#endif
