/*
 * cfgmgr_Datapool_PublicItem.cpp
 *
 *  Created on: Mar 19, 2018
 *      Author: ogm5kor
 */

#ifndef CFGMGR_DATAPOOL_PUBLICITEM_H_
#include "cfgmgr_Datapool_PublicItem.h"
#endif

DLT_IMPORT_CONTEXT (CFM0)
DLT_IMPORT_CONTEXT (CMIT)

cfgmgr_Datapool_PublicItem::cfgmgr_Datapool_PublicItem()
{
	m_Result = DP_S32_NO_ERR;
}

cfgmgr_Datapool_PublicItem::~cfgmgr_Datapool_PublicItem()
{

}

/************************************************************************************************/
/************************************************************************************************/
Cfgmgr_ItemStatus_T cfgmgr_Datapool_PublicItem::vSetCSA(tStr sKey, tStr sVal)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_Datapool_PublicItem::vSetCSA");
	Cfgmgr_ItemStatus_T status = STATUS_SUCCESS;

	status = vSetCSAValueValid(sVal);
	if(status == STATUS_SUCCESS)
	{
		dp_tclConfigManagerDatapoolDataCSA dp_CSA;
		strncpy(m_Data.sKey,sKey.c_str(),MAX_LEN_KEY);
		m_Data.sKey[MAX_LEN_KEY - CFGMGR_ONE] = '\0';
		strncpy(m_Data.sValue,sVal.c_str(),MAX_LEN_CSA);
		m_Data.sValue[MAX_LEN_CSA - CFGMGR_ONE] = '\0';

		dp_CSA.vSetData(m_Data);
		m_Result = dp_CSA.s32GetStatus();

		if( DP_S32_NO_ERR != m_Result)
		{
			log(&CMIT,DLT_LOG_ERROR,"UNABLE TO STORE THE VALUE TO DATAPOOL. ERROR CODE : ",m_Result);
			status = STATUS_FAILED;
		}
	}

	return status;
}

/************************************************************************************************/
Cfgmgr_ItemStatus_T cfgmgr_Datapool_PublicItem::vGetCSA(vector<ConfigData_T>& publicItem,ConfigData_T &data)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_Datapool_PublicItem::vGetCSA");
	Cfgmgr_ItemStatus_T status = STATUS_SUCCESS;

	dp_tclConfigManagerDatapoolDataCSA dp_CSA;
	m_Result = dp_CSA.s32GetData(m_Data);

	if(DP_S32_NO_ERR != m_Result)
	{
		log(&CMIT,DLT_LOG_ERROR,"UNABLE TO READ DATAPOOL. ERROR CODE : ",m_Result);
		status = STATUS_FAILED;
	}
	else
	{
		data.key = m_Data.sKey;
		data.value = m_Data.sValue;
		publicItem.push_back(data);
	}

	return status;
}

/************************************************************************************************/
Cfgmgr_ItemStatus_T cfgmgr_Datapool_PublicItem::vSetCSAValueValid(tStr &sValue)
{
	 tUInt16 i = 0;
	 tUInt32 dataVal;
	 Cfgmgr_ItemStatus_T status = STATUS_FAILED;
	 if (!sValue.empty())
	 {
		 if(sValue[CFGMGR_ZERO] == '+')
		 {
			 sValue = sValue.substr(1,sValue.length());
		 }

		 if(!is_digits(sValue))
		 {
			 log(&CMIT,DLT_LOG_ERROR,"INVALID VALUE");
			 return STATUS_INAVLID_VALUE;
		 }
	 }
	 else
	 {
		 log(&CMIT,DLT_LOG_ERROR,"VALUE IS EMPTY");
		 return STATUS_INAVLID_VALUE;
	 }

	 stringstream strInt(sValue);
	 strInt >> dataVal;

	 if((CFGMGR_ZERO == dataVal) || (CFGMGR_ONE == dataVal))
	 {
		 stringstream intStr;
		 intStr << dataVal;
		 sValue = intStr.str();
		 status = STATUS_SUCCESS;
	 }
	 else
	 {
		 log(&CMIT,DLT_LOG_ERROR,"INVALID VALUE");
		 status = STATUS_INAVLID_VALUE;
	 }
	 return status;
}
/************************************************************************************************/
/************************************************************************************************/
Cfgmgr_ItemStatus_T cfgmgr_Datapool_PublicItem::vSetURL(tStr sKey, tStr sVal)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_Datapool_PublicItem::vSetURL");
	Cfgmgr_ItemStatus_T status = STATUS_SUCCESS;

	if(sVal.length() > (MAX_LEN_URL - CFGMGR_ONE))
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH OF VALUE EXCEEDED");
		status = STATUS_INAVLID_VALUE;
	}
	else
	{
		dp_tclConfigManagerLocalDataURL dp_URL;
		strncpy(m_Data.sKey,sKey.c_str(),MAX_LEN_KEY);
		m_Data.sKey[MAX_LEN_KEY - CFGMGR_ONE] = '\0';
		strncpy(m_Data.sValue,sVal.c_str(),MAX_LEN_URL);
		m_Data.sValue[MAX_LEN_URL - CFGMGR_ONE] = '\0';

		dp_URL.vSetData(m_Data);
		m_Result = dp_URL.s32GetStatus();

		if( DP_S32_NO_ERR != m_Result)
		{
			log(&CMIT,DLT_LOG_ERROR,"UNABLE TO STORE THE VALUE TO DATAPOOL. ERROR CODE :: ",m_Result);
			status = STATUS_FAILED;
		}
	}

	return status;
}

/************************************************************************************************/
Cfgmgr_ItemStatus_T cfgmgr_Datapool_PublicItem::vGetURL(vector<ConfigData_T>& publicItem,ConfigData_T &data)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_Datapool_PublicItem::vGetURL");
	Cfgmgr_ItemStatus_T status = STATUS_SUCCESS;

	dp_tclConfigManagerLocalDataURL dp_URL;
	m_Result = dp_URL.s32GetData(m_Data);

	if(DP_S32_NO_ERR != m_Result)
	{
		log(&CMIT,DLT_LOG_ERROR,"UNABLE TO READ DATAPOOL. ERROR CODE : ",m_Result);
		status = STATUS_FAILED;
	}
	else
	{
		data.key = m_Data.sKey;
		data.value = m_Data.sValue;
		publicItem.push_back(data);
	}

	return status;
}

/************************************************************************************************/
/************************************************************************************************/
Cfgmgr_ItemStatus_T cfgmgr_Datapool_PublicItem::vSetPARTID(tStr sKey, tStr sVal)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_Datapool_PublicItem::vSetPARTID");
	Cfgmgr_ItemStatus_T status = STATUS_SUCCESS;

	if(sVal.length() > (MAX_LEN_PARTID - CFGMGR_ONE))
	{
		log(&CMIT,DLT_LOG_ERROR,"LENGTH OF VALUE EXCEEDED");
		status = STATUS_INAVLID_VALUE;
	}
	else
	{
		dp_tclConfigManagerLocalDataPARTID dp_PARTID;
		strncpy(m_Data.sKey,sKey.c_str(),MAX_LEN_KEY);
		m_Data.sKey[MAX_LEN_KEY - CFGMGR_ONE] = '\0';
		strncpy(m_Data.sValue,sVal.c_str(),MAX_LEN_PARTID);
		m_Data.sValue[MAX_LEN_PARTID - CFGMGR_ONE] = '\0';

		dp_PARTID.vSetData(m_Data);
		m_Result = dp_PARTID.s32GetStatus();

		if( DP_S32_NO_ERR != m_Result)
		{
			log(&CMIT,DLT_LOG_ERROR,"UNABLE TO STORE THE VALUE TO DATAPOOL. ERROR CODE :: ",m_Result);
			status = STATUS_FAILED;
		}
	}

	return status;
}

/************************************************************************************************/
Cfgmgr_ItemStatus_T cfgmgr_Datapool_PublicItem::vGetPARTID(vector<ConfigData_T>& publicItem,ConfigData_T &data)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_Datapool_PublicItem::vGetPARTID");
	Cfgmgr_ItemStatus_T status = STATUS_SUCCESS;

	dp_tclConfigManagerLocalDataPARTID dp_PARTID;
	m_Result = dp_PARTID.s32GetData(m_Data);

	if(DP_S32_NO_ERR != m_Result)
	{
		log(&CMIT,DLT_LOG_ERROR,"UNABLE TO READ DATAPOOL. ERROR CODE : ",m_Result);
		status = STATUS_FAILED;
	}
	else
	{
		data.key = m_Data.sKey;
		data.value = m_Data.sValue;
		publicItem.push_back(data);
	}

	return status;
}

/************************************************************************************************/
