/*
 * cfgmgr_DESCMOParser.cpp
 *
 *  Created on: Nov 14, 2017
 *      Author: ogm5kor
 */

#ifndef CFGMGR_DESCMOPARSER_H_
#include "cfgmgr_DESCMOParser.h"
#endif

using namespace std;
DLT_IMPORT_CONTEXT (CFM0)

cfgmgr_DESCMOParser* cfgmgr_DESCMOParser::pDESCMOParser = NULL;

cfgmgr_DESCMOParser::cfgmgr_DESCMOParser():_xml(""),_rootNode(NULL) {
	// TODO Auto-generated constructor stub
	customPresent = false;
}

cfgmgr_DESCMOParser::~cfgmgr_DESCMOParser() {
	// TODO Auto-generated destructor stub
}

cfgmgr_DESCMOParser* cfgmgr_DESCMOParser::getInstanceofDESCMOParser()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOParser::getInstanceofDESCMOParser");

	if (NULL == pDESCMOParser)
	{
		pDESCMOParser = new cfgmgr_DESCMOParser();
	}

	return pDESCMOParser;
}

tVoid cfgmgr_DESCMOParser::extractCustomSetting(tStr &_xmlData, tStr &line)
{
	std::size_t found = line.find("customSetting");
	if (found != std::string::npos)
	{
		if(customPresent == false)
		{
			customPresent = true;
		}
	}

	if (customPresent)
	{
		_xmlData.append(line);
	}

	std::size_t endfound = line.find("/customSetting");
	if (endfound != std::string::npos)
	{
		if(customPresent == true)
		{
			customPresent = false;
		}
	}
}

tbool cfgmgr_DESCMOParser::parseXml(tStr xmlFile,tStr &_xmlData, tStr &_xmlSignature, tStr &_profileName)
{
	_xml = xmlFile;
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOParser::parseXml: parsing file - ",_xml.c_str());

	_xmlData.clear();

	std::ifstream infile(_xml.c_str());
	if(infile)
	{
		tStr line;
		while (std::getline(infile, line))
		{
			extractCustomSetting(_xmlData,line);
		}
	}

	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOParser: _xmlData - ", _xmlData.c_str());

	if (_xmlDoc.LoadFile(_xml.c_str()))
	{
		_rootNode = _xmlDoc.RootElement();
		if(_rootNode)
		{
			if(parseParameters(_xmlSignature,_profileName))
			{
				return true;
			}
		}
		else
		{
			log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOParser::parseXml xmlParseError [RootNode is NULL]");
		}
	}
	else
	{
		log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOParser::parseXml xmlParseError ",_xmlDoc.ErrorId(), " .. ", _xmlDoc.ErrorDesc());
	}
	return false;

}

tbool cfgmgr_DESCMOParser::extractProfileName(tStr &_profileName, TiXmlElement* elem)
{
	/* Getting Profile Name */
	TiXmlElement* contentProName=NULL;
	contentProName=elem->FirstChildElement("customSetting");

	if(contentProName)
	{
		for(; contentProName; contentProName=contentProName->NextSiblingElement())
		{
			if(strcmp(contentProName->Value(), "customSetting"))
			{
				log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOParser::parseParameters expected tag \"customSetting\" but found ", contentProName->Value());
				break;
			}
			else
			{
				if(!getAttribute(_profileName, contentProName, "method"))
				{
					break;
				}
				else
				{
					log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOParser::parseParameters Profile Name ",_profileName.c_str());
				}
			}
		}
	}
	else
	{
		log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOParser::parseParameters xmlParseError [customSetting Element is Absent]");
		return false;
	}

	return true;
}

tbool cfgmgr_DESCMOParser::extractXmlSignature(tStr &_xmlSignature, TiXmlElement* elem)
{
	/* Getting Profile Name */
	TiXmlElement* content=NULL;
	content=elem->FirstChildElement("signatures");
	if(content)
	{
		TiXmlElement* contentFile=NULL;
		contentFile=content->FirstChildElement("profile_signatures");
		if(contentFile)
		{
			TiXmlElement* contentFileData=NULL;
			contentFileData=contentFile->FirstChildElement("signature");

			for(; contentFileData; contentFileData=contentFileData->NextSiblingElement())
			{
				if(strcmp(contentFileData->Value(), "signature"))
				{
					log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOParser::parseParameters expected tag \"signature\" but found ", contentFileData->Value());
					break;
				}
				else
				{
					if(!getAttribute(_xmlSignature, contentFileData, "Sign_value"))
					{
						break;
					}
					else
					{
						log(&CFM0,DLT_LOG_INFO,"cfgmgr_Communication::parseParameters Sign_value:",_xmlSignature.c_str());
					}
				}
			}
		}
		else
		{
			log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOParser::parseParameters xmlParseError [profile_signatures Element is Absent]");
			return false;
		}
	}
	else
	{
		log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOParser::parseParameters xmlParseError [signatures Element is Absent]");
		return false;
	}

	return true;
}

bool cfgmgr_DESCMOParser::parseParameters(tStr &_xmlSignature, tStr &_profileName)
{
	TiXmlElement* elem=NULL;
	elem=getRootNode();
	if(elem)
	{
		log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOParser::parseParameters searching for Content in ", elem->Value());

		/* Getting Profile Name */
		if(!extractProfileName(_profileName,elem))
		{
			return false;
		}

		/* Getting the Signature Text */
		if(!extractXmlSignature(_xmlSignature,elem))
		{
			return false;
		}
	}
	else
	{
		log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOParser::parseParameters xmlParseError [RootNode is NULL]");
	}
	return false;
}

tbool cfgmgr_DESCMOParser::getAttribute(tStr &outString, const TiXmlElement* base, const char* value)
{
	const char *attrib_value=base->Attribute(value);

	if(attrib_value)
	{
		outString.assign(attrib_value);
		return true;
	}

	outString.assign("");
	return false;
}
