/**
 * @file   : cfgmgr_DESCMOHandler.cpp
 * @author : mrr8kor
 * @date   : Aug 20, 2017
 * @brief  : To manage communications with DESCMO library
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifdef __OTA_COMPONENT_ENABLE__
#ifndef CFGMGR_DESCMOHANDLER_H_
#include "cfgmgr_DESCMOHandler.h"
#endif

/***********************************************************************************************/
/* 							cfgmgr_DESCMOHandler Constructor								   */
/***********************************************************************************************/
cfgmgr_DESCMOHandler::cfgmgr_DESCMOHandler(tStr xmlData,tStr xmlSignature,tStr VIN)
//mp_DescmoPtr(NULL) //TODO - Need to uncomment once proper implementation is available
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOHandler::cfgmgr_DESCMOHandler() constructor");

	mp_DescmoPtr = new DescmoReader(xmlData,xmlSignature,VIN);
}

/***********************************************************************************************/
/* 							cfgmgr_DESCMOHandler Destructor									   */
/***********************************************************************************************/
cfgmgr_DESCMOHandler::~cfgmgr_DESCMOHandler()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOHandler::cfgmgr_DESCMOHandler() Destructor");

	if(NULL != mp_DescmoPtr)
	{
		delete mp_DescmoPtr;
		mp_DescmoPtr = NULL;
	}
}

/***********************************************************************************************/
/* 							Request to DESCMO to validate data								   */
/***********************************************************************************************/
cfgmgr_descmoResult cfgmgr_DESCMOHandler::validateData()
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOHandler::validateData");
	cfgmgr_descmoResult result;

	fcota::DescmoReader::tenDescmoResult res = mp_DescmoPtr->isValid();

	result = this->getDescmoResult(res);

	return result;
}

/***********************************************************************************************/
/* 	Decode XML data using DESCMO library. This is required for Ntive Apps only					*/
/***********************************************************************************************/
cfgmgr_descmoResult cfgmgr_DESCMOHandler::decodeXMLData(map<tStr,tStr> &configData,stCustomSetData &customeData)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOHandler::decodeXMLData");

	cfgmgr_descmoResult result = ADDITIONAL_DATA_VALIDATION_FAILED;
	configData.clear();

	result = validateCustomSetEntries(mp_DescmoPtr->getSettingName(),customeData.Name);
	if(SUCCESS == result)
	{
		result = validateCustomSetEntries(mp_DescmoPtr->getSettingMethod(),customeData.MethodName);
		if(SUCCESS == result)
		{
			result = validateCustomSetEntries(mp_DescmoPtr->getSettingActionType(),customeData.ActionType);
			if(SUCCESS == result)
			{
				result = validateCustomSetEntries(mp_DescmoPtr->getSettingECU(),customeData.ECUName);
				if(SUCCESS == result)
				{
					// Copying the key value pairs and preparing the map
					configData.insert(mp_DescmoPtr->getItems().begin(),mp_DescmoPtr->getItems().end());
				}
				else
				{
					log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOHandler::decodeXMLData -- Get SettingECU Failed");
				}
			}
			else
			{
				log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOHandler::decodeXMLData -- Get SettingActionType Failed");
			}
		}
		else
		{
			log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOHandler::decodeXMLData -- Get SettingMethod Failed");
		}
	}
	else
	{
		log(&CFM0,DLT_LOG_ERROR,"cfgmgr_DESCMOHandler::decodeXMLData -- Get SettingName Failed");
	}

	return result;
}

/***********************************************************************************************/
/*                           Check if data exists for a CustomSet							   */
/***********************************************************************************************/
cfgmgr_descmoResult cfgmgr_DESCMOHandler::validateCustomSetEntries(tStr data ,tStr &retData)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOHandler::validateCustomSetEntries");

	cfgmgr_descmoResult result = ADDITIONAL_DATA_VALIDATION_FAILED;
	if(!data.empty())
	{
		retData = data;
		result = SUCCESS;
	}

	return result;
}

/***********************************************************************************************/
/*                       Prepare result in XML format to send back to Ota					   */
/***********************************************************************************************/
cfgmgr_descmoResult cfgmgr_DESCMOHandler::prepareXMLData(map<tStr,tStr> configData,tStr &xmlData)
{
	log(&CFM0,DLT_LOG_INFO,"cfgmgr_DESCMOHandler::prepareXMLData");

	cfgmgr_descmoResult result;
	map<tStr,tStr>::iterator it = configData.begin();
	log(&CFM0,DLT_LOG_INFO,"key -",it->first, " value- ", it->second );

	fcota::DescmoReader::tenDescmoResult res = mp_DescmoPtr->handleDescmoGet(configData,xmlData);
	result = this->getDescmoResult(res);

	return result;
}

cfgmgr_descmoResult cfgmgr_DESCMOHandler::getDescmoResult(fcota::DescmoReader::tenDescmoResult res)
{
	cfgmgr_descmoResult result;

  	switch(res)
	{
	case fcota::DescmoReader::SUCCESS:
		result = SUCCESS;
		break;
	case fcota::DescmoReader::CANCELLED:
		result = CANCELLED;
		break;
	case fcota::DescmoReader::TIMEOUT:
		result = TIMEOUT;
		break;
	case fcota::DescmoReader::PARTIAL:
		result = PARTIAL;
		break;
	case fcota::DescmoReader::INVALID:
		result = INVALID;
		break;
	case fcota::DescmoReader::NOT_SUPPORTED:
		result = NOT_SUPPORTED;
		break;
	case fcota::DescmoReader::ECU_NOT_EXIST:
		result = ECU_NOT_EXIST;
		break;
	case fcota::DescmoReader::SETTINGS_EXECUTION_TIMEOUT:
		result = SETTINGS_EXECUTION_TIMEOUT;
		break;
	case fcota::DescmoReader::ADDITIONAL_DATA_VALIDATION_FAILED:
		result = ADDITIONAL_DATA_VALIDATION_FAILED;
		break;
	case fcota::DescmoReader::SETTINGS_PROFILE_SIGNATURE_INVALID:
		result = SETTINGS_PROFILE_SIGNATURE_INVALID;
		break;
	case fcota::DescmoReader::SETTINGS_SIGNATURE_INVALID:
		result = SETTINGS_SIGNATURE_INVALID;
		break;
	default:
		result = FAILED;
		break;
	}
  	return result;
}
#endif
