/**
 * @file   : cfgmgr_ClientDatabase.h
 * @author : mrr8kor
 * @date   : Aug 24, 2017
 * @brief  : Client Configtable to store registrations from application
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
 
#ifndef CFGMGR_CLIENTDATABASE_H_
#define CFGMGR_CLIENTDATABASE_H_

#include <iostream>
#include "boost/shared_ptr.hpp"
#include <de/bosch/cm/ConfigManager/ConfigData.h>
#include <de/bosch/cm/ConfigManager/ConfigDataProxy.h>
#include <de/bosch/cm/ConfigManager/ConfigManagement.h>

#ifndef CFGMGR_DLTWRAPPER_H_
#include "../trace/cfgmgr_DltWrapper.h"
#endif

DLT_IMPORT_CONTEXT (CFM0)
DLT_IMPORT_CONTEXT (CMIT)
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
using namespace ::asf::core;
using namespace cfmg;
using namespace de::bosch::cm::ConfigManager::ConfigData;
using namespace de::bosch::cm::ConfigManager::ConfigManagement;

class cfgmgr_ClientDatabase
{
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(cfgmgr_ClientDatabase);

public:

   //! destructor
   virtual ~cfgmgr_ClientDatabase ( tVoid )
   {
	   delete m_poClientDatabaseObj;
	   m_poClientDatabaseObj = NULL;
   }

   static cfgmgr_ClientDatabase* createProxyDatabaseObject()
   {
	   if(m_poClientDatabaseObj == NULL)
	   {
		   m_poClientDatabaseObj =  new  cfgmgr_ClientDatabase();
	   }
	   return m_poClientDatabaseObj;
   }
   
   tVoid storePrivateAppInfo(tStr configItemName,tStr DbusName,::boost::shared_ptr<ConfigDataProxy > proxy,FormatIdentifier formatId);
   tVoid storePublicAppInfo(tStr configItemName,tStr DbusName,::boost::shared_ptr<ConfigDataProxy > proxy,FormatIdentifier formatId);
   
   Reg_Status_T deletePrivateAppInfo(tStr configItemName,tStr DbusName);
   Reg_Status_T deletePublicAppInfo(tStr configItem,tStr DbusName);
		 
   Reg_Status_T searchForConfigItemName(tStr configItem , tStr Dbus, ListType type);

   tbool getFormatIdType(tStr configItem,tbool &isCfgMgrRegistered, FormatIdentifier &formatId);
   tVoid getConfigItemList(tStr itemType);

   tbool getProxy(tStr profileName,::boost::shared_ptr<ConfigDataProxy> &proxy,ListType type);

   tbool getProxyforRegisteredPublicItem(tStr profileName, vector< ::boost::shared_ptr<ConfigDataProxy> > &proxy );

   tbool getListofAllPublicItemNames (map<tStr,DatapoolType> &publicItemList);
   tVoid getProxyRegItem(tStr profileName,tStr dbusname,::boost::shared_ptr<ConfigDataProxy> &proxy);
   tbool compareItemName(tStr RegItemName, tStr ItemName);

   DatapoolType getDpType(tStr ItemName,tStr &pKey);

   tVoid fillCfgMgrPrivateItems();

   typedef struct ProxyList
   {
	   tStr configItemName;
	   tStr DBUSName;
	   FormatIdentifier formatFlag;
	   DatapoolType dpType;
	   tStr pKey;
	   ::boost::shared_ptr<ConfigDataProxy > proxy;
   }ProxyList_T;

	typedef struct PublicValueList
	{
		tStr configItemName;
		std::map<tStr, tStr> m_mapPublicItem;
	}PublicValueList_T;

private:

   //! constructor
   cfgmgr_ClientDatabase ();

   //self refered pointer
   static cfgmgr_ClientDatabase* m_poClientDatabaseObj;
       
   std::vector<ProxyList_T> m_poPublicProxyList;
   std::vector<ProxyList_T> m_poPrivateProxyList;
   std::vector<ProxyList_T> m_PublicItemTable;		// LOCALITEM TEST
};

#endif /* CM_COMMUNICATION_H_ */
