/**
 * @file   : cfgmgr_DiagnosisClient.h
 * @author : mrr8kor
 * @date   : Aug 24, 2017
 * @brief  : To handle systemsettings with Diagnosis component
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
 
#ifndef CFGMGR_DIAGNOSIS_CLIENT_H_
#define CFGMGR_DIAGNOSIS_CLIENT_H_

#include <iostream>
#include "asf/core/BaseComponent.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusProxy.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Stub.h"

#ifndef CFGMGR_CLIENTDATABASE_H_
#include "../framework/cfgmgr_ClientDatabase.h"
#endif

#ifndef CFGMGR_DEFAULT_SETTING_HANDLER_H_
#include "../framework/cfgmgr_DefaultSettingHandler.h"
#endif

using namespace ::asf::core;
using namespace cfmg;

namespace asf{
using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;

class cfgmgr_DiagnosisClient :public BaseComponent,
							  public SystemSettings1Stub
{
	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(cfgmgr_DiagnosisClient);
public:
	cfgmgr_DiagnosisClient() :SystemSettings1Stub("cfgmgrSystemSettingPort"), _SysSettingPtr(NULL)
	{
		log(&CFM0,DLT_LOG_INFO,"cfgmgr_DiagnosisClient::cfgmgr_DiagnosisClient Constructor");

		_SysSettingPtr = new cfgmgr_DefaultSettingHandler();

	}
	virtual ~cfgmgr_DiagnosisClient()
	{
		log(&CFM0,DLT_LOG_INFO,"cfgmgr_DiagnosisClient::cfgmgr_DiagnosisClient Destructor");

		if(NULL != _SysSettingPtr)
		{
			delete _SysSettingPtr;
			_SysSettingPtr = NULL;
		}
	}

	virtual tVoid onPrepareSystemSettingRequest(const ::boost::shared_ptr< PrepareSystemSettingRequest >& request);
	virtual tVoid onExecuteSystemSettingRequest(const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request);
	virtual tVoid onFinalizeSystemSettingRequest(const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request);

private:
	cfgmgr_ISysSetHandler *_SysSettingPtr;

};
}

#endif /* CFGMGR_DIAGNOSIS_CLIENT_H_ */
