/**
 * @file   : cfgmgr_Communication.h
 * @author : mrr8kor
 * @date   : Aug 24, 2017
 * @brief  : Handle ASF communication
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
 
#ifndef CFGMGR_COMMUNICATION_H_
#define CFGMGR_COMMUNICATION_H_

#include <iostream>

#ifndef cfgmgr_UpdateManager_H_
#include "../framework/cfgmgr_UpdateManager.h"
#endif

#ifndef cfgmgr_DataRequestHandler
#include "../framework/cfgmgr_DataRequestHandler.h"
#endif

#ifndef CFGMGR_DESCMOPARSER_H_
#include "../framework/cfgmgr_DESCMOParser.h"
#endif

#ifndef CFGMGR_DLTWRAPPER_H_
#include "../trace/cfgmgr_DltWrapper.h"
#endif


//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
using namespace ::asf::core;
using namespace cfmg;

class cfgmgr_Communication
{
public:

   virtual ~cfgmgr_Communication ( tVoid );

   static cfgmgr_Communication* createCMCommunicationObject()
   {
	   if(m_poCMCommunicationObj == NULL)
	   {
		   m_poCMCommunicationObj =  new  cfgmgr_Communication();
	   }
	   return m_poCMCommunicationObj;
   }

   tbool bOnInit();
   std::vector<tStr> getStringList(std::string &str,tChar delimiter,tUInt32 size);
   std::vector<ConfigData_T> getKeyValuePairList(tStr str);

   static tSInt32 CFGMGR_TEST_SET_PRIVATE_DATA(tUInt32 service_id, tVoid *data, tUInt32 length);
   static tSInt32 CFGMGR_TEST_GET_PRIVATE_DATA(tUInt32 service_id, tVoid *data, tUInt32 length);
   static tSInt32 CFGMGR_TEST_SET_PUBLIC_DATA(tUInt32 service_id, tVoid *data, tUInt32 length);
   static tSInt32 CFGMGR_TEST_GET_PUBLIC_DATA(tUInt32 service_id, tVoid *data, tUInt32 length);
   static tSInt32 CFGMGR_TEST_SEND_DATA_XML(tUInt32 service_id, tVoid *data, tUInt32 length);
   static tSInt32 CFGMGR_PrintPrivateRegistrationTable(tUInt32 service_id, tVoid *data, tUInt32 length);
   static tSInt32 CFGMGR_PrintPublicRegistrationTable(tUInt32 service_id, tVoid *data, tUInt32 length);
   static tSInt32 CFGMGR_TEST_SET_MAP_UPDATE_REGION_SETID(tUInt32 service_id, tVoid *data, tUInt32 length);

private:

   //! constructor
   cfgmgr_Communication ();

   //self refered pointer
   static cfgmgr_Communication* m_poCMCommunicationObj;
   
};

#endif /* CFGMGR_COMMUNICATION_H_ */
