/**
 * @file   : cfgmgr_ASFOtaClient.h
 * @author : mrr8kor
 * @date   : Aug 24, 2017
 * @brief  : To manage requests/ response to Fc_ota
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */

#ifndef CFGMGR_ASF_OTA_CLIENT_H_
#define CFGMGR_ASF_OTA_CLIENT_H_

#include <iostream>
#include "asf/core/BaseComponent.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusProxy.h"
#include "boost/shared_ptr.hpp"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrv.h"
#include "fcota_descmo_ecu_srv/FcOtaDescmoEcuSrvProxy.h"

#ifndef cfgmgr_DataRequestHandler_H_
#include "../framework/cfgmgr_DataRequestHandler.h"
#endif

#ifndef CFGMGR_INTERFACE_OTACLIENT_LISTENER
#include "../interfaces/cfgmgr_IOtaClientListener.h"
#endif

#ifndef cfgmgr_UpdateManager_H_
#include "../framework/cfgmgr_UpdateManager.h"
#endif

using namespace ::asf::core;
using namespace cfmg;

namespace asf{

using namespace fcota_descmo_ecu_srv::FcOtaDescmoEcuSrv;

class cfgmgr_ASFOtaClient: public BaseComponent,
						   public ServiceAvailableIF,
						   public DescmoStateCallbackIF,
						   public RegisterEcuCallbackIF,
						   public SetDescmoResultCallbackIF,
						   public cfgmgr_IOtaClientListener
{
   public:

	cfgmgr_ASFOtaClient();
	~cfgmgr_ASFOtaClient();

	// ServiceAvailableIF implementation
    virtual tVoid onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange) ;

    virtual tVoid onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange) ;

	// DescmoStateCallbackIF implementation
	virtual tVoid onDescmoStateError(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< DescmoStateError >& error);

	virtual tVoid onDescmoStateUpdate(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< DescmoStateUpdate >& update);

	// RegisterEcuCallbackIF implementation
	virtual tVoid onRegisterEcuError(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< RegisterEcuError >& error);

	virtual tVoid onRegisterEcuResponse(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< RegisterEcuResponse >& response);
	
	// SetDescmoResultCallbackIF implementation
	virtual tVoid onSetDescmoResultError(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< SetDescmoResultError >& error);

	virtual tVoid onSetDescmoResultResponse(const ::boost::shared_ptr< FcOtaDescmoEcuSrvProxy >& proxy, const ::boost::shared_ptr< SetDescmoResultResponse >& response);

	tVoid sendResponseToComponent(const tUInt32 ECUId,const tUInt32 CorrelatorId,const tUInt32 ErrorCode,const tStr xmlData);

   private:
	 //proxy pointer
     ::boost::shared_ptr<FcOtaDescmoEcuSrvProxy> m_poOtaProxy;

     cfgmgr_DataRequestHandler* m_pRequestHandler;

     cfgmgr_DataRequestHandler* getInstanceofDataRequestHandler();

     DescmoState_T m_descmoData;
};
}

#endif /* CFGMGR_ASF_OTA_CLIENT_H_ */
