/**
 * @file   : cfgmgr_ASFAppClient.h
 * @author : mrr8kor
 * @date   : Aug 24, 2017
 * @brief  : Functionality to communicate with Applications
 * @copyright (c) 2017 Robert Bosch Car Multimedia Gmbh
 * @addgroup : cfgmgr
 * @{
 */
 
#ifndef CFGMGR_ASF_APPCLIENT_H_
#define CFGMGR_ASF_APPCLIENT_H_

#include <iostream>
#include "asf/core/BaseComponent.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusProxy.h"
#include "boost/shared_ptr.hpp"
#include "de/bosch/cm/ConfigManager/ConfigData.h"
#include "de/bosch/cm/ConfigManager/ConfigDataProxy.h"

#ifndef CFGMGR_CLIENTDATABASE_H_
#include "../framework/cfgmgr_ClientDatabase.h"
#endif

#ifndef cfgmgr_UpdateManager_H_
#include "../framework/cfgmgr_UpdateManager.h"
#endif

#ifndef CFGMGR_INACLIENTHANDLER_H_
#include "../interfaces/cfgmgr_INAClientHandler.h"
#endif

using namespace ::asf::core;
using namespace cfmg;

namespace asf{

using namespace de::bosch::cm::ConfigManager::ConfigData;

class cfgmgr_ASFAppClient: public BaseComponent,
								 public ServiceAvailableIF,
								 public ExchangeDESCMOCallbackIF,
								 public GetPrivateItemCallbackIF,
								 public SetPrivateItemCallbackIF,
								 public cfgmgr_INAClientHandler
{

   public:
	cfgmgr_ASFAppClient();

    virtual ~cfgmgr_ASFAppClient();
	//--------------------------------------------------------------------------
	// ServiceAvailableIF implementation
	//--------------------------------------------------------------------------

    virtual tVoid onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange) ;

    virtual tVoid onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange) ;

	virtual tVoid onSetPrivateItemError(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< SetPrivateItemError >& error);

	virtual tVoid onSetPrivateItemResponse(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< SetPrivateItemResponse >& response);

	virtual tVoid onGetPrivateItemError(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< GetPrivateItemError >& error);

	virtual tVoid onGetPrivateItemResponse(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< GetPrivateItemResponse >& response);

	virtual tVoid onExchangeDESCMOError(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< ExchangeDESCMOError >& error);

	virtual tVoid onExchangeDESCMOResponse(const ::boost::shared_ptr< ConfigDataProxy >& proxy, const ::boost::shared_ptr< ExchangeDESCMOResponse >& response);

	//--------------------------------------------------------------------------
	// Methods inherited from cfgmgr_INAClientHandler
	//--------------------------------------------------------------------------
	
	tVoid updatePrivateData(DescmoState_T configItem, ConfigItem_T data, ::boost::shared_ptr<ConfigDataProxy > proxy);

	tVoid updatePublicData(tStr itemName, ConfigItem_T data, ::boost::shared_ptr<ConfigDataProxy > proxy);

	tVoid SendXMLData(DescmoState_T configItem, ::boost::shared_ptr<ConfigDataProxy > proxy);
	
	tVoid getPrivateData(DescmoState_T configItem, ::boost::shared_ptr<ConfigDataProxy > proxy);

	::boost::shared_ptr<ConfigDataProxy > createProxy(tStr Dbus_Name);

   private:

	cfgmgr_UpdateManager* m_pUpdateManager;

	cfgmgr_UpdateManager* getInstanceOfUpdateManager();

	struct ItemList_T
	{
		act_t ActID;
		DescmoState_T configItem;
		tStr actionType;
	}m_Item;

};
}

#endif /* CFGMGR_ASF_APPCLIENT_H_ */
