/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : AVRoutingParsingError.cpp
 * COMPONENT Name      : AVRoutingParsingError
 * @details         :
 * AUTHOR              : Sunil Sagar
 * Date                : 08.03.2020
 * Revision History    : 0.1
 * Date 03.08.2020     : Initial version
 */

#ifndef AVDECC_APPL_PLUGINS_AVROUTING_PARSER_INC_AVROUTINGPARSINGERROR_H_
#define AVDECC_APPL_PLUGINS_AVROUTING_PARSER_INC_AVROUTINGPARSINGERROR_H_
#include <string>
#include "system_types.h"

class tclAvRoutingParsingError {
public:
	enum {
		AVROUTING_NO_ERROR = 0,
		AVROUTING_ERROR = 1,
		AVROUTING_ERROR_OPENING_FILE = 2,
		AVROUTING_ERROR_OUT_OF_MEMORY = 3,
		AVROUTING_ERROR_PARSING_ELEMENT = 4,
		AVROUTING_ERROR_FAILED_TO_READ_ELEMENT_NAME = 5,
		AVROUTING_ERROR_READING_ELEMENT_VALUE = 6,
		AVROUTING_ERROR_READING_ATTRIBUTES = 7,
		AVROUTING_ERROR_PARSING_EMPTY = 8,
		AVROUTING_ERROR_READING_END_TAG = 9,
		AVROUTING_ERROR_PARSING_UNKNOWN = 10,
		AVROUTING_ERROR_PARSING_COMMENT = 11,
		AVROUTING_ERROR_PARSING_DECLARATION = 12,
		AVROUTING_ERROR_DOCUMENT_EMPTY = 13,
		AVROUTING_ERROR_EMBEDDED_NULL = 14,
		AVROUTING_ERROR_PARSING_CDATA = 15,
		AVROUTING_ERROR_DOCUMENT_TOP_ONLY = 16,
		AVROUTING_ERROR_STRING_COUNT = 17,
		AVROUTING_ERROR_DUPLICATE_ENTITYID = 18,
		AVROUTING_ERROR_DUPLICATE_ENTITYIP = 19,
		AVROUTING_ERROR_DEVICE_UNAVAILABLE = 20
	 };
private:
	tU8 m_u8ErrorCode;
	std::string m_sErrorDesc;
public:
	tclAvRoutingParsingError();
	virtual ~tclAvRoutingParsingError();
	tU8 u8GetErrorCode();
	tVoid vSetErrorCode(tU8 u8ErrorCode);
	tVoid vSetErrorDescription(std::string sErrorDesc);
	std::string sGetErrorDescription();
};

#endif /* AVDECC_APPL_PLUGINS_AVROUTING_PARSER_INC_AVROUTINGPARSINGERROR_H_ */

