/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * @file               : AVRoutingParser.h
 * @brief      : AVRoutingParser
 * @detail         :
 * @author              : Sunil Sagar
 * @Date                : 27.04.2020
 * Revision History    : 1.0
 * Date 27.04.2020     : Initial version
 * Date 28.05.2020     : Reviewed version
 */
#ifndef AVDECC_APPL_PLUGINS_AVROUTING_PARSER_H_
#define AVDECC_APPL_PLUGINS_AVROUTING_PARSER_H_

#include "tinyxml.h"
#include "EntityInfo.h"
#include "AVRoutingParsingError.h"

class tclAvRoutingParser : public tclEntityInfo{
private:
	struct tEntity{
		std::string m_sname;
		tU64  m_u64eId = 0; 
		std::string m_sIP;
		std::string m_sMac;
		std::string m_sinkLinkName;
		tSettingNameValueMap m_entitySetting;
	};
	tSinkLinkCabinMap m_entitySinkLinkCabin;
	tCabinChannelMap m_entityCabinChannelMap;
	enum class tPhylInfo{
		ENTITY_ID,
		ENTITY_IP,
		ENTITY_MAC
	};
	std::vector<tEntity> m_entityDetail;
	tVecCamData m_camData;
	vecCamPortInfo m_caminfo;
	vecCamPortSplitInfo m_camSplitViewInfo;
	tVecCamData m_IPCameraData;
	tBool m_bParseState;
	tBool m_bPosTag;
	tclAvRoutingParsingError m_parsingErrorObj;
	static tclAvRoutingParser* m_pInstance;
	tclAvRoutingParser();
	tclAvRoutingParser(const tclAvRoutingParser&)= delete;
	tclAvRoutingParser& operator=(const tclAvRoutingParser&) = delete;
	tBool bParseEntity(TiXmlElement* pElement);
	tVoid vGetEntityInfo(tPhylInfo phyInfo,tCString pDevName, std::vector<std::string>&entityData);
	tVoid vParseSetting(TiXmlElement* pElement,tEntity &entityDetail);
	tVoid vParseChannelnfo(TiXmlElement* pElement,tEntity &entityDetail);
	tVoid vValidateDeviceEntry(const tEntity &entityData );
	tVoid vValidateDeviceEntry();
	tVoid vExtractLinkInfo(TiXmlElement* pElement);
	tVoid vSetEntityLinkInfo(TiXmlElement* pElement,tEntity &entityDetail);
	tVoid vParseCameraInfo(TiXmlElement* pElement);
public:
	~tclAvRoutingParser();
	static tclAvRoutingParser* pGetInstance();
	// Helpful for plugins to get EntityID of device
	tEntityIdVector vectorGetEntityID(tCString pDevName );
	// Helpful for LCM to get EntityIp of device
	tEntityIPVector vectorGetEntityIP(tCString pDevName );
	//Currently no usecase but for future use
	tEntityMacVector vectorGetEntityMac(tCString pDevName );
	// To check entity Id exist
	tBool bIsEntityIdExist(const tU64 u64EntityId );
	// To check IP exist
	tBool bIsIpExist(tCString pEntityIp);
	//Parsing xml API
	tBool bParseXml();
	//Setting Info for Media Glass
	tSettingNameValueMap mapGetMediaGlassSetting(const tU64 u64EntityId);
	//Get all the device list
	tEntityNameIPMap mapGetCompleteDeviceList();
	//Get mapping of cabin and device location
	tSinkLinkCabinMap mapGetSinkCabinLinkList();
	//Get mapping of CabinChannel Details
	tCabinChannelMap getCabinChannelMap();
	//Get Error code 
	tU8 u8GetErrorCode();
	//Get Error Description 
	std::string sGetErrorDescription();
	//Get Entity Sink Link Name for Cabin Info  
	std::string sGetEntitySinkLinkName(const tU64 u64EntityId);
	//Get Entity IP with given entity Id
	std::string sGetEntityIP(const tU64 u64EntityId);
	//Print device list
	virtual tVoid vPrintDeviceList();
	//Get Entity Name with given entity Id
	std::string sGetEntityName(const tU64 u64EntityId);
	//Get all the camera attribute values
	tVecCamData vecGetCamSrc();
	//Get camera position based on entityid
	uint16_t u16GetCamPos(tU64 u64EntityId);
	//Get camera position based on IPaddress
	uint16_t u16GetCamPos(std::string strIP);
	//To check if position tag si available
	tBool bIsPosTagAvailable();
	
	vecCamPortSplitInfo vecGetSplitCamInfo();
	std::vector<std::string> getSourceNamesForSplitView(std::string strSrcName, int position);
	tVecSplitCamData m_camSplitData;
	tVecSplitCamData vecGetSplitCamSrc();
	tVecCamData vecGetIPCamSrcData();
	static bool sortIPcameraListOnPosition(tCamData& a, tCamData& b);
};
#endif /* AVDECC_APPL_PLUGINS_AVROUTING_PARSER_H_ */
