/* ***************************************************************************************
* FILE:          clPluginQueueThread.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clPluginQueueThread.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CL_PluginQueueTHREAD_H
#define CL_PluginQueueTHREAD_H

#include <map> 
#include <vector>
#include <algorithm>
using namespace std;

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
class clPluginBase;
typedef void (clPluginBase::*FUNCPTR)(uint16_t, uint64_t);
typedef std::pair<clPluginBase *, FUNCPTR> PairObjFuncPtr;
typedef std::pair<std::string, int> PairEntityDescIndex;
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "clPluginDataProvider.h"
#include "clControlMapping.h"
#include "AVRoutingParser.h"
#include <pthread.h>
#include <mutex>
#include <queue>
class clPluginQueueThread
{

public:
	clPluginQueueThread(clPluginDataProvider *pPluginMain);
	virtual ~clPluginQueueThread();
	bool bCreatePluginQueuethread();
	bool setPluginQueueEvent(NotificationData& tData);
	std::string bFindEntityName(NotificationData myData);

	
private:
	clPluginQueueThread(); //Not Allowed
	clPluginQueueThread(const clPluginQueueThread&);
	clPluginQueueThread& operator =(const clPluginQueueThread&);
	static clPluginDataProvider *m_pPluginMain;
	void * thThreadStart(void * args);
	bool processQueue();
	bool addPluginDataToQueue(std::shared_ptr<NotificationData> pluginData);
	//int bFindEntityID(uint64_t u64EntID);
	vector<std::shared_ptr<NotificationData>> *m_thPluginQueue;
	//std::shared_ptr<NotificationData> m_thPluginCurrentContainer;
	clControlMapping* _pCtrlMap;
	vector<stEntityDesc> vecEndStation;
	std::multimap<PairEntityDescIndex, PairObjFuncPtr> m_mapResp;
		
	//Thread related declarations
	pthread_cond_t m_thWaitCond;
	//pthread_mutex_t m_thMutexLock;
	pthread_t m_threadID;
	
};
#endif // !defined(CL_PluginQueueTHREAD_H)
