/* ***************************************************************************************
* FILE:          clEndStationThread.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clEndStationThread.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CL_ENDSTATIONTHREAD_H
#define CL_ENDSTATIONTHREAD_H

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "clPluginDataProvider.h"
#include "AVRoutingParser.h"
#include <pthread.h>
#include <mutex>
#include "CommandToPlugin/CommandToPlugin.h"
class clEndStationThread
{

public:
	clEndStationThread(clPluginDataProvider *pPluginMain);
	virtual ~clEndStationThread();
	bool bCreateEndStationthread();
	void setEndStationEvent();
	void EntityDisConnected(uint64_t entity_id);
	void RecvMsgFromEndStation(boost::shared_ptr<EventDataUtility> dataUtility);
	void RecvListMsgFromEndstation(boost::shared_ptr<EventDataUtility> dataUtility,
		const boost::shared_ptr<EventListDataUtility> eListData);
	void EndStationToDataUtility(std::vector<std::string> vEndStationList);
	std::vector<stCamDesc> vecGetCamDesc();
	bool m_bParseState;

	
private:
	clEndStationThread(); //Not Allowed
	static clPluginDataProvider *m_pPluginMain;
	void * thThreadStart(void * args);
	bool bExtractEndStationInfo();
	vector<stCamDesc> vecStCamDesc;
	std::vector<stEntityDetailsToAppl> vecStEntityDetailsToAppl;
	
	//Thread related declarations
	pthread_cond_t m_thWaitCond;
	//pthread_mutex_t m_thMutexLock;
	pthread_t m_threadID;
	tclEntityInfo *m_pEntityInfo;
	std::vector<std::string> vEndStationList;
	void setEntityDetailsToAppl(stEntityDesc &tEntityDetails);
	void EntityDetailsToListDataUtility(std::vector<stEntityDetailsToAppl> vStEntityDetails);
	
};
#endif // !defined(CL_ENDSTATIONTHREAD_H)
