/* ***************************************************************************************
* FILE:          clControlMapping.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clControlMapping.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  Supriya Seshadri(RBEI/ECG5) 07/08/2020
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#ifndef CL_CONTROLPLUGIN_H
#define CL_CONTROLPLUGIN_H

#include <map> 
#include <vector>
#include <algorithm>
using namespace std;


/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

class clControlMapping;
class clPluginBase;

typedef void (clPluginBase::*FUNCPTR)(uint16_t, uint64_t);
typedef std::pair<clPluginBase *, FUNCPTR> PairObjFuncPtr; //Value for the MultiMpa
typedef std::pair<std::string, int> PairEntityDescIndex; //key for the MultiMulp


class clControlMapping
{
public:
	clControlMapping();
	~clControlMapping();
	static clControlMapping *getInstance();
	static void deleteInstance();
	void clearMappingContent();
	void setRespCallBack(std::string entityname, int controlblock, clPluginBase *ptr, FUNCPTR func);
	vector<PairObjFuncPtr> getRespCallBack(std::string strEntityName, int controlblock);
	std::multimap<PairEntityDescIndex, PairObjFuncPtr> getMappingContent();

private:
//Map will hold the key as the Desc Index and the Entity of this DEsc Index
//Value of each key will be the plgin helper class's Function Pointer which
//will handle the respective Control Desc Index call backs from the different Entities
	static std::multimap<PairEntityDescIndex, PairObjFuncPtr> m_mapRespCallback;
	static clControlMapping* poSelf;
};

#endif //CL_CONTROLPLUGIN_H