/* ***************************************************************************************
* FILE:          clRouterPlugin.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clRouterPlugin.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CL_ROUTERPLUGIN_H
#define CL_ROUTERPLUGIN_H

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"


#include "clPluginBase.h"
#include "PluginDataType.h"
#include "clCommunicationProtocol.h"
#include "PluginConstants.h"


/* Datapool */
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_hmi_11_if.h"
#endif


class HandlerRegistration;
class Object;
class Event;


class clRouterPlugin : public clPluginBase
{

public:
	clRouterPlugin();
	static clRouterPlugin* getInstance();	
	static void deleteInstance();
	virtual ~clRouterPlugin();
	virtual void vEventESReadComplete();
		
	//Event functions
	virtual std::unique_ptr<HandlerRegistration> addPluginEventHandler();
    virtual std::unique_ptr<Event> getPluginEvent(Object* sender, 
												   const std::string msg, 
												   boost::shared_ptr<EventDataUtility> evalue);
    virtual std::unique_ptr<Event> getPluginListEvent(Object* sender,
                                                       const std::string msg,
													   boost::shared_ptr<EventDataUtility>eData,
													   const boost::shared_ptr<EventListDataUtility>& eListData);
													  
	 void setPluginData(std::string key, const boost::shared_ptr<EventDataUtility>& eValue);
	 void setPluginListData(std::string key, const boost::shared_ptr<EventDataUtility>& eData,
	 const boost::shared_ptr<EventListDataUtility>& eListData);
	void vSetStreamCurrentTrackIndex(uint32_t streamTrackIndex,uint16_t Filetype);


private:
	static clRouterPlugin* poSelf;
	std::vector <stEntityDesc> m_CMREntity;
	stEntityDesc m_stPrimCMR;
	void vCreateGetControlCommand(stEntityDesc EntityDescriptor,uint8_t u8ControlId);
	void vCreateSetControlCommand(uint8_t u8ControlId,uint8_t u8ControlVal);
	bool isEntityDescriptorAvailable(stEntityDesc EntityDescriptor);
	void vRegisterCmr(stEntityDesc EntityDescriptor);
	
	void vSetStreamFolderCurrentTrackIndex(uint32_t FolderstreamTrackIndex,uint16_t FolderFiletype);

	//Call back
        void vRouterDbAvailableResponse(uint16_t cmd_type,uint64_t entity_id);
        void vStream1TotalPlayTime(uint16_t cmd_type,uint64_t entity_id);
        void vStream1CurrentPlayTime(uint16_t cmd_type,uint64_t entity_id);
        void vRouterUsbStatusResponse(uint16_t cmd_type,uint64_t entity_id);
        void vRouterStream1VideoNameResponse(uint16_t cmd_type,uint64_t entity_id);
        void vRouterStream1VideoEpisodeResponse(uint16_t cmd_type,uint64_t entity_id);
        void vRouterStream1PlayBackActionResponse(uint16_t cmd_type,uint64_t entity_id);
        void vRouterStream1SeekToResponse(uint16_t cmd_type,uint64_t entity_id);
        void vCheckSumStatusResponse(uint16_t cmd_type,uint64_t entity_id);
        void vSetStream1CurrentTrackIndex (uint32_t streamTrackIndex);
        void vStream1CurTrackIndexLowByteResponse(uint16_t cmd_type,uint64_t entity_id);
        void vStream1CurTrackIndexHighByteResponse(uint16_t cmd_type,uint64_t entity_id);
		double vConvertTimeInSecs(std::string timevalue);
		void vCheckCRCStatus();
		void vHandleAudioVideoPlayBackAction(uint8_t u8ControlId, uint8_t u8PlayAction);
		void vHandlePlaybackAction(std::vector<EventDataItem*> dataItems);
		void vHandlePlaybackMode(std::vector<EventDataItem*> dataItems);
		void vUsbentitiesupdate();
		
		void vVideosourcerestoreinpause();
        void vStream3TotalPlayTime(uint16_t cmd_type,uint64_t entity_id);
        void vStream3CurrentPlayTime(uint16_t cmd_type,uint64_t entity_id);
        void vRouterStream3TrackNameResponse(uint16_t cmd_type,uint64_t entity_id);
        void vRouterStream3ArtistNameResponse(uint16_t cmd_type,uint64_t entity_id);
        void vRouterStream3PlayBackActionResponse(uint16_t cmd_type,uint64_t entity_id);
        void vRouterStream3SeekToResponse(uint16_t cmd_type,uint64_t entity_id);
		void vSetStream3CurrentTrackIndex (uint32_t stream3TrackIndex);
        void vStream3CurTrackIndexLowByteResponse(uint16_t cmd_type,uint64_t entity_id);
        void vStream3CurTrackIndexHighByteResponse(uint16_t cmd_type,uint64_t entity_id);
		
		void VReadCMRdatafromdatapool();
		void VclearCMRdatapool();
		void vRenameifInvalidUTF8isFound(std::string &Name);
		void vVideosourcerestoreinpoause();
		void VWritedatapool();
	

	typedef void (clRouterPlugin::*EMPFUNCPTR)(const boost::shared_ptr<EventDataUtility>&);
	
	void vSendPluginResponseToHmi(uint32_t u32DescIndex,std::string strData);
	void vSendPluginResponseToHmi(uint32_t u32DescIndex,uint8_t uint8Value);
    void vRegisterResponseCallbacks();

	clCommunicationProtocol *m_pCommControl;
	ControlDataElement controlElementCheckSum;
	std::string m_strCurrentCheckSum;
	std::string m_strPrevCheckSum;
	uint8_t* pValue;
	uint8_t m_u8TrackIndex_HighByte;
	uint8_t m_u8TRackIndex_LowByte;
	uint8_t m_PlayControlId;
	uint8_t m_PlayState;
	uint8_t m_dbstatus;
	bool m_bPlayAction;
	bool m_busbStatus;
	bool m_bvideosourcerestore;
	struct PlayBackAction
	{
		uint16_t u8Region;
		uint16_t u8ListType;
		uint16_t u16TrackIndex;
		uint8_t AuidoPLaybackMode;
		uint8_t VideoPLaybackMode;
		uint16_t u16Filter1;
		uint16_t u16Filter2;
		std::string FolderPath;
		uint16_t u16Filetype;
		uint8_t SubSourceType;
	};	
	PlayBackAction m_CabinTrackInfo;
};
#endif // !defined(CL_ROUTERPLUGIN_H)



