/* ***************************************************************************************
* FILE:          clPluginBase.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clPluginBase.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CL_PLUGIN_BASE_H
#define CL_PLUGIN_BASE_H

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include <cstdint>
#include <iostream>
#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"
#include "PluginEventBase.h"
#include "PluginEvtListenerBase.h"
#include "PluginDataType.h"

class clPluginBase
{

public:
	clPluginBase();
	virtual ~clPluginBase();
	virtual void vEventESReadComplete() = 0;
	void RecvMsgFromPlugin(const std::string sender_info, const std::string ctrl_block,boost::shared_ptr<EventDataUtility> dataUtility);
    void RecvListMsgFromPlugin(const std::string sender_info, const std::string ctrl_block,boost::shared_ptr<EventDataUtility> dataUtility,
		const boost::shared_ptr<EventListDataUtility> eListData);
};
#endif // !defined(CL_PLUGIN_BASE_H)
