/* ***************************************************************************************
* FILE:          clPluginBase.cpp
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clPluginBase.cpp is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include <clPluginBase.h>
#include "plugin_trace.h"

#include "CommandToPlugin/CommandToPlugin.h"

//#include "XMLRead.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_PLUGIN_MAIN
#include "trcGenProj/Header/clPluginBase.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

clPluginBase::clPluginBase(){

}

clPluginBase::~clPluginBase(){

}

void clPluginBase::RecvMsgFromPlugin(const std::string sender_info, const std::string ctrl_block,boost::shared_ptr<EventDataUtility> dataUtility)
{
     ETG_TRACE_USR4(("clPluginBase::RecvMsgFromPlugin enter"));
	 CommandToPlugin* _commandFromPlugin = CommandToPlugin::poGetInstance();
	 HandlerRegistration* pluginReg = nullptr;
	 //create object of common plugin
	 PluginEventBase<CommonPlugin> pluginEvent(_commandFromPlugin, CommonPlugin::getInstance(), ctrl_block, dataUtility, sender_info);

	 //create object of Plugin Listener
	 PluginEvtListenerBase<CommonPlugin>* pluginEventListener = PluginEvtListenerBase<CommonPlugin>::getInstance();

	 //add handler
     pthread_mutex_lock(&m_thMutexLock);
	 if(pluginEventListener != NULL)
	 {
		 ETG_TRACE_USR4(("clPluginBase::RecvMsgFromPlugin inside if pluginEventListener"));
		 pluginReg = EventBus::AddHandler<PluginEventBase<CommonPlugin>>(pluginEventListener);
		 if(pluginReg != NULL){
			 ETG_TRACE_USR4(("clPluginBase::RecvMsgFromPlugin pluginReg is not NULL"));
		 }
		 else
			 ETG_TRACE_USR4(("clPluginBase::RecvMsgFromPlugin pluginReg is NULL"));
	 }

	 //fire the event
	 ETG_TRACE_USR4(("clPluginBase::RecvMsgFromPlugin before fire event"));
	 EventBus::FireEvent(pluginEvent);
	 ETG_TRACE_USR4(("clPluginBase::RecvMsgFromPlugin after fire event"));
	 //remove handler after event fire else handlers keep incrementing everytime and multiple events are fired
	 pluginReg->removeHandler();
     pthread_mutex_unlock(&m_thMutexLock);
	 ETG_TRACE_USR4(("clPluginBase::RecvMsgFromPlugin after removeHandler"));

	 delete pluginReg;
     ETG_TRACE_USR4(("clPluginBase::RecvMsgFromPlugin exit"));
}

void clPluginBase::RecvListMsgFromPlugin(const std::string sender_info, const std::string ctrl_block,boost::shared_ptr<EventDataUtility> dataUtility,
		const boost::shared_ptr<EventListDataUtility> eListData)
{
	 
     ETG_TRACE_USR4(("clPluginBase::RecvListMsgFromPlugin enter"));
	 CommandToPlugin* _commandFromPlugin = CommandToPlugin::poGetInstance();
	 HandlerRegistration* pluginReg = nullptr;
	 //create object of common plugin
	 PluginEventBase<CommonPlugin> pluginEvent(_commandFromPlugin, CommonPlugin::getInstance(), ctrl_block, dataUtility,eListData,sender_info);

	 //create object of Plugin Listener
	 PluginEvtListenerBase<CommonPlugin>* pluginEventListener = PluginEvtListenerBase<CommonPlugin>::getInstance();

	 //add handler
     pthread_mutex_lock(&m_thMutexLock);
	 if(pluginEventListener != NULL)
	 {
		 pluginReg = EventBus::AddHandler<PluginEventBase<CommonPlugin>>(pluginEventListener);
	 }

	 //fire the event
	 EventBus::FireEvent(pluginEvent);
	 //remove handler after event fire else handlers keep incrementing everytime and multiple events are fired
	 pluginReg->removeHandler();
     pthread_mutex_unlock(&m_thMutexLock);
	 delete pluginReg;
     ETG_TRACE_USR4(("clPluginBase::RecvListMsgFromPlugin exit"));
}
