/* ***************************************************************************************
* FILE:          clMasterControlPlugin.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clMasterControlPlugin.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  vta5kor
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CL_MASTERCONTROLPLUGIN_H
#define CL_MASTERCONTROLPLUGIN_H

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"


#include "clPluginBase.h"
#include "PluginDataType.h"
#include "clCommunicationProtocol.h"
#include "PluginConstants.h"
#include "AVRoutingParser.h"


class HandlerRegistration;
class Object;
class Event;

class clMasterControlPlugin : public clPluginBase
{

public:
	clMasterControlPlugin();
	static clMasterControlPlugin* getInstance();	
	static void deleteInstance();
	virtual ~clMasterControlPlugin();
	virtual void vEventESReadComplete();
	
	
	
	//Event functions
	virtual std::unique_ptr<HandlerRegistration> addPluginEventHandler();
    virtual std::unique_ptr<Event> getPluginEvent(Object* sender, 
												   const std::string msg, 
												   boost::shared_ptr<EventDataUtility> evalue);
    virtual std::unique_ptr<Event> getPluginListEvent(Object* sender,
                                                       const std::string msg,
													   boost::shared_ptr<EventDataUtility>eData,
													   const boost::shared_ptr<EventListDataUtility>& eListData);
													  
      void setPluginData(std::string key, const boost::shared_ptr<EventDataUtility>& eValue);
      void setPluginListData(std::string key, const boost::shared_ptr<EventDataUtility>& eData,
      const boost::shared_ptr<EventListDataUtility>& eListData);	
	// Funtion pointers
      void setMapFuncs();
	 
    void onStreamSelection(const boost::shared_ptr<EventDataUtility>& eValue);
    void onVolumeControlChange(const boost::shared_ptr<EventDataUtility>& eValue);
    void onMixSourceChange(const boost::shared_ptr<EventDataUtility>& eValue);
    void onBeepVolumeChange(const boost::shared_ptr<EventDataUtility>& eValue);
    void onBeepOutputUpdate(const boost::shared_ptr<EventDataUtility>& eValue);


	//Presentation Time Offset
    void onSetPresentationTimeOffset(const boost::shared_ptr<EventDataUtility>& eValue);

	// Max Transit time
    void onSetMaxTransitTime(const boost::shared_ptr<EventDataUtility>& eValue);
    void selectStream(uint8_t sinkId, uint8_t streamType);
	
private:
	clMasterControlPlugin(const clMasterControlPlugin&);
	clMasterControlPlugin& operator =(const clMasterControlPlugin&);
	static clMasterControlPlugin* poSelf;
	std::vector <stEntityDesc> m_CMPEntityDetails;
	std::vector <stEntityDesc> m_CMAEntityDetails;
	
	std::vector<stEntityDesc> m_AMediaGlassList;
    std::vector<stEntityDesc> m_A2MediaGlassList;
    std::vector<stEntityDesc> m_B1MediaGlassList;
    std::vector<stEntityDesc> m_B2MediaGlassList;
	tclEntityInfo *m_pEntityInfo;
	uint16_t m_U16BeepVolume;
	
	
	typedef void (clMasterControlPlugin::*CAMFUNCPTR)(const boost::shared_ptr<EventDataUtility>&);
    	typedef std::map<std::string, CAMFUNCPTR> FuncMap;
    	FuncMap m_MemberFunctionMap;
    	std::map <uint8_t ,uint8_t> m_mapVolume;
	
	
	bool bFindEntityInList(uint64_t u64EntityID, std::vector<stEntityDesc> MediaGlass, uint32_t &entityIndex);
	void UpdateCMPEntityDetails(std::vector<stEntityDesc> stEntityDetails);
	void UpdateCMAEntityDetails(std::vector<stEntityDesc> stEntityDetails);
	void UpdateCMGEntityDetails(std::vector<stEntityDesc> stEntityDetails);
	void vSetControlUINT8(avdecc_lib::configuration_descriptor * configuration, uint32_t u32ControlDescIdx, uint8_t uint8Value);
	void SetTransitTimeControl(uint8_t source,uint8_t value);
	void SetPresentationTimeControl(uint8_t source,uint8_t sinkId,uint16_t Offset);
	void SetMixSourceValues(uint8_t sinkid,uint8_t source);
	void SetBeepVolume(uint8_t sinkid,uint8_t volume);
	uint8_t u8GetVolume_dBValue (uint8_t u8Volume);
	void SetBeepOutput(uint8_t sinkid,uint8_t value);
	void vIntializeVolumeMap ();

	int m_CabinApreviousStreamType;
	int m_CabinA2previousStreamType;
	
	clCommunicationProtocol *m_pCommControl;
	
};
#endif // !defined(CL_MASTERCONTROLPLUGIN_H)
