/* ***************************************************************************************
* FILE:          clCameraPlugin.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clCameraPlugin.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CL_CAMERAPLUGIN_H
#define CL_CAMERAPLUGIN_H

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"


#include "clPluginBase.h"
#include "PluginDataType.h"
#include "clCommunicationProtocol.h"
#include "PluginConstants.h"
#include "EntityInfo.h"
#include "AVRoutingParser.h"


//defines used locally in camera plugin
#define ONE 1
#define TWO 2
#define THREE 3
#define FOUR 4
#define ONECMP_MAXCAMERAS 5
#define IPCAM_INCMP 4
#define CAMLIST_STARTUP 100
//

class HandlerRegistration;
class Object;
class Event;

class clCameraPlugin : public clPluginBase
{

public:
	clCameraPlugin();
	static clCameraPlugin* getInstance();	
	static void deleteInstance();
	virtual ~clCameraPlugin();
	virtual void vEventESReadComplete();
	//Call backs from Plugin
    void vHandleCamera1Status(uint16_t cmd_type,uint64_t entity_id);
    void vHandleCamera2Status(uint16_t cmd_type,uint64_t entity_id);
    void vHandleCamera3Status(uint16_t cmd_type,uint64_t entity_id);
    void vHandleCamera4Status(uint16_t cmd_type,uint64_t entity_id);
    void vHandleCameraCVBSStatus(uint16_t cmd_type,uint64_t entity_id);
    void vHandleCameraSplitCamStatus(uint16_t cmd_type,uint64_t entity_id);
    void vHandleCameraIPCamStatus(uint16_t cmd_type,uint64_t entity_id);
	
	
	//Event functions
	virtual std::unique_ptr<HandlerRegistration> addPluginEventHandler();
    virtual std::unique_ptr<Event> getPluginEvent(Object* sender, 
												   const std::string msg, 
												   boost::shared_ptr<EventDataUtility> evalue);
    virtual std::unique_ptr<Event> getPluginListEvent(Object* sender,
                                                       const std::string msg,
													   boost::shared_ptr<EventDataUtility>eData,
													   const boost::shared_ptr<EventListDataUtility>& eListData);
													  
	 void setPluginData(std::string key, const boost::shared_ptr<EventDataUtility>& eValue);
     void setPluginListData(std::string key, const boost::shared_ptr<EventDataUtility>& eData,
	 const boost::shared_ptr<EventListDataUtility>& eListData);	
	// Funtion pointers
	 void setMapFuncs();
	 
	 //Call backs from HMI Requests
	void vCreateSetControlCommand(uint16_t u16ControlId,uint16_t u16CMPPosition, std::string strCameraSource);
	uint16_t m_u16LastExecutedSetCommand;
	void fillDataInVector(int indexCMP, int loopSize);
	
	void sendCameraListDataToHMI();//CameraList cameraDataToHMI);
	void sendCameraListOnHMIRequest(); // new method added to handle request from HMI.
	void sendSetControlForCascadedCamera(uint16_t u16ControlId,int position);
	std::map<std::string, int> mapCmpSrc_AvdeccValue;
	void getAvdeccValue(std::string camSrc, int &avdeccValue);
	void readCameraConfig();
	tclAvRoutingParser* _avRoutingParser;
	tVoid vValidateCamInfo();
	static void TraceCmd_sendSetControlCommand(uint16_t u16ControlId,uint16_t u16ControlVal, uint16_t position);
	//void fillTestDataToHMI();
	void vCheckAndAddIPCamera(int numberOfCMPs);
	void vCheckAndAddSplitCamera(int numberOfCMPs);
	tVoid vPrintCamInfo();
	void fillSplitDataInVector(int indexCMP, int loopSize);
	std::string strSplitCamSrcName[3] = {"cockpitSplitView1", "cockpitSplitView2", "cockpitSplitView3"};
	int getSplitAvdeccValue(int position, std::string cameraSrc);
	void vPrepareAvdeccValuesForSplitCameras();
	int m_numberofCMPS;
	int getIPCameraIndexFromCamport(std::string ipcamstr);
	bool bPrimaryDetected;

private:
	clCameraPlugin(const clCameraPlugin&);
	clCameraPlugin& operator =(const clCameraPlugin&);
	static clCameraPlugin* poSelf;
	vector<stEntityDesc> m_CMPEntityDetails;
	
	typedef void (clCameraPlugin::*CAMFUNCPTR)(const boost::shared_ptr<EventDataUtility>&);
	int getCamportIndex(int position);
    typedef std::map<std::string, CAMFUNCPTR> FuncMap;
    FuncMap m_MemberFunctionMap;
	std::vector<stCamDesc> vecStCamDesc;
	
	clCommunicationProtocol *m_pCommControl;
	tVecCamData m_caminfo;
	tVecCamData vecCamDataToHmi;
	tVecCamData vecCamDataOnHmiRequest;
	tVecCamData CameraList;
	tCamData CL;
	
	vecCamPortSplitInfo m_splitCaminfo;
    vecCamPortAvdeccSplitValue	m_splitAvdeccinfo;
	tVecSplitCamData m_camSplitData;
    void vRegisterResponseCallbacks();
};
#endif // !defined(CL_CAMERAPLUGIN_H)
