/* ***************************************************************************************
* FILE:          clCommunicationProtocol.h
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clCommunicationProtocol.h is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CL_COMMUNICATION_PROTOCOL_H
#define CL_COMMUNICATION_PROTOCOL_H

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include <stdint.h>
#include <unistd.h>
#include <string>
#include <vector>
#include <algorithm>

using namespace std;


#include "entity_descriptor.h"
#include "configuration_descriptor.h"
#include "audio_unit_descriptor.h"
#include "stream_input_descriptor.h"
#include "stream_output_descriptor.h"
#include "control_descriptor.h"
#include "control_descriptor_response.h"

#include "ACClientInterface.h"
#include "PluginDataType.h"
class clCommunicationProtocol
{

public:

	~clCommunicationProtocol();
	void setACClientInterface(ACClientInterface *clientif);
	ACClientInterface* getACClientInterface();
	bool setControl(ControlDataElement &controlData );
	bool getControl(ControlDataElement &controlData );
	void RegisterUnSolicitedResponse(avdecc_lib::end_station * end_station);
	void GetControlValue(ControlDataElement &controlData );
	void GetUnsolicitedValue(ControlDataElement &controlData );
	clCommunicationProtocol(); 

	
	
	//void vGetUTF8Value(ACClientInterface *m_pDaemonClient, ControlDataElement &controlData );
			
private:
	//static ACClient Interface as there should be only 1 interface
	//for the PluginMain
	avdecc_lib::control_descriptor * getControlDescriptor(ControlDataElement &controlData);	

 static ACClientInterface *m_pDaemonClient;	
 
	
};
#endif // !defined(CL_COMMUNICATION_PROTOCOL_H)
