/* ***************************************************************************************
* FILE:          clCommunicationProtocol.cpp
* SW-COMPONENT:  avdecc_appl_plugins
* DESCRIPTION:  clCommunicationProtocol.cpp is part of avdecc_appl_plugins library
* COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
* HISTORY: 
* AUTHOR:  
* REVISION: 
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include <clCommunicationProtocol.h>
#include "plugin_trace.h"

//#include "XMLRead.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_PLUGIN_MAIN
#include "trcGenProj/Header/clCommunicationProtocol.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN


 ACClientInterface *clCommunicationProtocol::m_pDaemonClient = NULL;

/************************************************************************
*FUNCTION: 		clCommunicationProtocol()
*DESCRIPTION   : Constructor of the class clCommunicationProtocol
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	ess7kor	11/05/2020
*************************************************************************/
clCommunicationProtocol::clCommunicationProtocol(){
//m_pDaemonClient = NULL;
}

/************************************************************************
*FUNCTION: 		setACClientInterface(ACClientInterface *clientif)
*DESCRIPTION   : Sets the m_pDaemonClient memeber variable
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	ess7kor	11/05/2020
*************************************************************************/
void clCommunicationProtocol::setACClientInterface(ACClientInterface *clientif) {
	
m_pDaemonClient = 	clientif;
ETG_TRACE_USR4(("clCommunicationProtocol::setACClientInterface()m_pDaemonClient %d", m_pDaemonClient));
}

/************************************************************************
*FUNCTION: 		clCommunicationProtocol(ACClientInterface *clientif)
*DESCRIPTION   : Parameterised constructor of the class clCommunicationProtocol
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	ess7kor	11/05/2020
*************************************************************************/
ACClientInterface* clCommunicationProtocol::getACClientInterface() {
ETG_TRACE_USR4(("clCommunicationProtocol::getACClientInterface()m_pDaemonClient %d", m_pDaemonClient));
return m_pDaemonClient;
}

/************************************************************************
*FUNCTION: 		~clCommunicationProtocol()
*DESCRIPTION   : Destructor of the class ~clCommunicationProtocol
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	ess7kor	11/05/2020
*************************************************************************/
clCommunicationProtocol::~clCommunicationProtocol(){

}


/************************************************************************
*FUNCTION: 		vSetControl()
*DESCRIPTION   :vSetControl is an avdecc command function to set some controls in the
*				connected entities
*PARAMETER:		ACClientInterface *m_pDaemonClient : the avdecc interface
*				ControlDataElement &controlData
*RETURNVALUE: 	status of the setcontrol 
*HISTORY:
*revision 0.1	ess7kor	11/05/2020
*************************************************************************/
bool clCommunicationProtocol::setControl(ControlDataElement &controlData)
{
	bool status = false;
	ETG_TRACE_FATAL(("clCommunicationProtocol::setControl called "));
	if (NULL != m_pDaemonClient) {
		ETG_TRACE_FATAL(("clCommunicationProtocol::m_pDaemonClient not NULL"));
		
		avdecc_lib::control_descriptor * control = getControlDescriptor(controlData);

		if (control == NULL) {
			ETG_TRACE_FATAL(("setControl FAILED as control is NULL"));
			return status;
		}

		//get a notification ID from daemon. This will be valid until notification callback
		ACNotificationId *cmd_notification_id = m_pDaemonClient->get_async_notification_id();

		//attch your private obj to the ID
		if (cmd_notification_id == NULL){
			ETG_TRACE_FATAL(("setControl cmd_notification_id is NULL"));
			return status;
		}

		//pass ID with command
		if (control->send_set_control_cmd(cmd_notification_id, (char*)&controlData.uint8Value, (uint16_t) sizeof(uint8_t)) < 0){
			ETG_TRACE_FATAL(("send_set_control_cmd is done"));
			status = true;
		}
	}
	else
	{
		ETG_TRACE_FATAL(("clCommunicationProtocol::m_pDaemonClient NULL"));
	}
	return status;
}


/************************************************************************
*FUNCTION: 		vGetControl()
*DESCRIPTION   :vGetControl is an avdecc command function to get some controls in the
*				connected entities
*PARAMETER:		ACClientInterface *m_pDaemonClient : the avdecc interface
*				ControlDataElement &controlData
*RETURNVALUE: 	status of the setcontrol 
*HISTORY:
*revision 0.1	ess7kor	11/05/2020
*************************************************************************/
bool clCommunicationProtocol::getControl(ControlDataElement &controlData)
{
	bool status = false;
	if (NULL != m_pDaemonClient) {
		avdecc_lib::control_descriptor * control = getControlDescriptor(controlData);

		if (control == NULL) {
			return status;
		}

		//get a notification ID from daemon. This will be valid until notification callback
		ACNotificationId *cmd_notification_id = m_pDaemonClient->get_async_notification_id();

		//attch your private obj to the ID
		if (cmd_notification_id == NULL){
			return status;
		}

		//pass ID with command
		if (control->send_get_control_cmd(cmd_notification_id)){
			status = true;
		}
	}
	return status;
}



/************************************************************************
*FUNCTION: 		getControlDescriptor()
*DESCRIPTION   :vGetControl is an avdecc command function to get the control
*				interface
*PARAMETER:		ACClientInterface *m_pDaemonClient : the avdecc interface
*				ControlDataElement &controlData
*RETURNVALUE: 	Control_descriptor interface
*HISTORY:
*revision 0.1	ess7kor	11/05/2020
*************************************************************************/
avdecc_lib::control_descriptor * clCommunicationProtocol::getControlDescriptor(ControlDataElement &controlData){
   
   avdecc_lib::configuration_descriptor * configuration = NULL;

   if(controlData.configuration != NULL)
   {
       ETG_TRACE_USR4(("clCommunicationProtocol::controlData "));
       configuration= controlData.configuration;
   }
   else
   {
	ETG_TRACE_USR4(("clCommunicationProtocol::controlData is NULL"));
   }

   if(configuration == NULL)
	   return NULL;
   avdecc_lib::control_descriptor * control = NULL;

   if (controlData.u32ControlDescIdx < configuration->control_desc_count()){
	   ETG_TRACE_USR4(("clCommunicationProtocol before accessing get_control_desc_by_index "));
		control = configuration->get_control_desc_by_index(controlData.u32ControlDescIdx);
		ETG_TRACE_USR4(("clCommunicationProtocol after accessing get_control_desc_by_index %d", controlData.u32ControlDescIdx));
   }

	return control;
}

void clCommunicationProtocol::RegisterUnSolicitedResponse(avdecc_lib::end_station * end_station)
{
	    //avdecc_lib::end_station *end_station = end_station;
		if( nullptr != m_pDaemonClient){
			ACNotificationId *cmd_notification_id = m_pDaemonClient->get_async_notification_id();
			if( nullptr != cmd_notification_id && nullptr != end_station){
				end_station->send_register_unsolicited_cmd((void *)cmd_notification_id);
			}
		}
}

void clCommunicationProtocol::GetControlValue(ControlDataElement &controlData )
{
	avdecc_lib::control_descriptor * control = getControlDescriptor(controlData);
	
	if (control == nullptr) {
		return;
	}
	int ret = -1;
	avdecc_lib::control_get_control_response * control_get_control_resp = control->get_control_get_control_response();

          
	ETG_TRACE_USR4(("clCommunicationProtocol::GetControlValue() controlData %d", controlData.u16Readlen));
        if (control_get_control_resp ==nullptr)
	{
        	ETG_TRACE_USR4(("clCommunicationProtocol::GetControlValue() control_get_control_resp is NULL"));
	}

	if (control_get_control_resp && controlData.u16Readlen > 2)
	{
		//cout.flush();
		char charData[512]= {0};
		ret = control_get_control_resp->get_control_control_utf(charData, controlData.u16Readlen);
		controlData.strGetValue = (std::string)charData;

	}
	else if ( control_get_control_resp && controlData.u16Readlen == 1)
	{
		ret = control_get_control_resp->get_control_control_lin_u8(controlData.puintGetValue, 1);
		controlData.uint8Value = *(controlData.puintGetValue); 
	}
	else if (control_get_control_resp && controlData.u16Readlen == 2)
	{
		//ret = control_get_control_resp->get_control_control_lin_u16(controlData.puintGetValue, 2);
	}
	else {
	}
	delete control_get_control_resp;
}

void clCommunicationProtocol::GetUnsolicitedValue(ControlDataElement &controlData )
{
	
	ETG_TRACE_USR4(("clCommunicationProtocol::GetUnsolicitedValue() controlData.u32ControlDescIdx %d",controlData.u32ControlDescIdx));
	avdecc_lib::control_descriptor * control = getControlDescriptor(controlData);
	
	if (control == nullptr) {
		return;
	}
	avdecc_lib::control_value_details time_details;
	avdecc_lib::control_descriptor_response *control_resp = control->get_control_response();
	if(nullptr != control_resp ){
		control_resp->value_details(time_details);
		controlData.strGetValue = (std::string)time_details.utf8[0].String;
		controlData.uint8Value	= (int8_t)time_details.l_int8[0].Current;
	ETG_TRACE_USR4(("clCommunicationProtocol::GetUnsolicitedValue() controlData.uint8Value %d", controlData.uint8Value));
        ETG_TRACE_USR4(("clCommunicationProtocol::GetUnsolicitedValue() controlData.u32ControlDescIdx %d",controlData.u32ControlDescIdx));
	}
}





