/*****************************************************************************
* FILE:         timestampsync_ServiceTimestampsync_srv_aIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: timestampsync
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// timestampsync_tclServiceTimestampsync_srv_aIfIncludes: user specific code start
// timestampsync_tclServiceTimestampsync_srv_aIfIncludes: user specific code end

#include "timestampsync_ServiceTimestampsync_srv_aIf.h"
#include "I_timestampsync_ServiceTimestampsync_srv_a.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_TIMESTAMPSYNC_SERVER_TIMESTAMPSYNC_SRV_A
#include "trcGenProj/Header/timestampsync_ServiceTimestampsync_srv_aIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: timestampsync_tclServiceTimestampsync_srv_aIf::
*             timestampsync_tclServiceTimestampsync_srv_aIf(timestampsync_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
timestampsync_tclServiceTimestampsync_srv_aIf::timestampsync_tclServiceTimestampsync_srv_aIf(timestampsync_tclAppMain* poMainAppl) : 
Itimestampsync_tclServiceTimestampsync_srv_aIf(poMainAppl)
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_aIf() entered."));
   _poServerRef = OSAL_NULL;

   // timestampsync_tclServiceTimestampsync_srv_aIfConstructor: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: timestampsync_tclServiceTimestampsync_srv_aIf::
*             ~timestampsync_tclServiceTimestampsync_srv_aIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
timestampsync_tclServiceTimestampsync_srv_aIf::~timestampsync_tclServiceTimestampsync_srv_aIf(tVoid)
{
   ETG_TRACE_USR4(("~timestampsync_tclServiceTimestampsync_srv_aIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // timestampsync_tclServiceTimestampsync_srv_aIfDestructor: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'timestampsync_ServiceTimestampsync_srv_aIf.h':
*     Add forward declaration:
*         class Itimestampsync_tclObject2Get;
*
*     Add declaration of object reference:
*         Itimestampsync_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Itimestampsync_tclObject2Get*>(_cpoMain->getHandler("Itimestampsync_tclObject2Get"));
*     TIMESTAMPSYNC_SRV_A_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_aIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Itimestampsync_tclServiceTimestampsync_srv_a*>(_cpoMain->getHandler("Itimestampsync_tclServiceTimestampsync_srv_a"));

   TIMESTAMPSYNC_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // timestampsync_tclServiceTimestampsync_srv_aIfvGetReferences: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_aIf::vStartCommunication() entered."));
   // timestampsync_tclServiceTimestampsync_srv_aIfvStartCommunication: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vHandleMessage(timestampsync_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_aIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(timestampsync_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // timestampsync_tclServiceTimestampsync_srv_aIfvHandleMessage: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vHandleTraceMessage(const tUChar* puchData)
{
   TIMESTAMPSYNC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_aIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // timestampsync_tclServiceTimestampsync_srv_aIfvHandleTraceMessage: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vTraceInfo()
{
   // timestampsync_tclServiceTimestampsync_srv_aIfvTraceInfo: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_aIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_aIf::onServiceAvailable() entered."));

   // timestampsync_tclServiceTimestampsync_srv_aIfvOnServiceAvailable: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid timestampsync_tclServiceTimestampsync_srv_aIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid timestampsync_tclServiceTimestampsync_srv_aIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("timestampsync_tclServiceTimestampsync_srv_aIf::onServiceUnavailable() entered."));

   // timestampsync_tclServiceTimestampsync_srv_aIfvOnServiceUnavailable: user specific code start
   // timestampsync_tclServiceTimestampsync_srv_aIfvOnServiceUnavailable: user specific code end
}



tVoid timestampsync_tclServiceTimestampsync_srv_aIf::sendU8EchoStatus(tU8 u8Data) {
    //just forward send request
    TIMESTAMPSYNC_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendU8EchoStatus(u8Data);
}







// timestampsync_tclServiceTimestampsync_srv_aIftimestampsync_ServiceTimestampsync_srv_aIf: user specific code start
// timestampsync_tclServiceTimestampsync_srv_aIftimestampsync_ServiceTimestampsync_srv_aIf: user specific code end

//EOF
