#ifndef __TIMESTAMPSYNC_timestampsyncAsfComponent_H
#define __TIMESTAMPSYNC_timestampsyncAsfComponent_H

/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file          timestampsyncAsfComponent.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: timestampsync
  * @Template:     AsfClient.h.tpl
  * @brief         generated file
  *                create the ASF component
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

#include "asf/stream/MemoryStream.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "timestampsync_AppMain.h"

namespace org { namespace bosch { namespace cm { namespace timestampsync {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::asf::core;
    using namespace::org::bosch::cm::timestampsync;

    void vProxyStarter(timestampsync_tclAppMain *poServer);

    class CcaSrvProxy;

    class TimestampsyncAsfComponent : public BaseComponent
    {
    private:
        timestampsync_tclAppMain  *_poCcaServer;
        CcaSrvProxy           *_poCcaSrvProxy;

        DECLARE_CLASS_LOGGER();

    public:
        TimestampsyncAsfComponent();
        virtual ~TimestampsyncAsfComponent();
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace timestampsync {

#endif // ifndef __TIMESTAMPSYNC_timestampsyncAsfComponent_H
