/*****************************************************************************
* FILE:         timestampsync_AppMain.h
* PROJECT:      G3G project
* SW-COMPONENT: timestampsync
* Template:     applMain.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


#ifndef _TIMESTAMPSYNCMAIN_H_
#define _TIMESTAMPSYNCMAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include <string>
#include <map>
#include <set>

#include "timestampsync_AppMain_Trace.h"

// timestampsync_tclAppMainIncludes: user specific code start
// timestampsync_tclAppMainIncludes: user specific code end

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


#define TIMESTAMPSYNC_NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }

#define TIMESTAMPSYNC_NULL_POINTER_CHECK_VAL(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return 0;\
   }

// timestampsync_tclAppMainDefine: user specific code start
// timestampsync_tclAppMainDefine: user specific code end


#define TRACE_BUFFER_MAXSIZE  250
#define TIMESTAMPSYNCINTERNAL_MSG_LEN    8       

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class timestampsync_tclAppMain;

// timestampsync_tclAppMainForwardDecl: user specific code start
// timestampsync_tclAppMainForwardDecl: user specific code end

////////////////////////////////////////////////////////////////////////////////
// Base class for all Classes
class timestampsync_tclBaseIf
{
protected:
   const timestampsync_tclAppMain*   _cpoMain;

public:
   typedef enum {
      //internal messages
      eSendTimeMSec = 0,
      eReceiveTimeMSec = 0,
      eTimeDiffMSec = 0,
      eTimeSyncActive = 1,
      eStartDelaySec = 2,
      eCmdIncMsgReceived = 100,

      // timestampsync_tclAppMainIMsgDef: user specific code start
      // timestampsync_tclAppMainIMsgDef: user specific code end

      eHeartbeat = 200,
      eCmdTraceCmdReceived,
      eCmdCsmSignalReceived,
      eCmdMCanChannelReady,
      eCmdMCanDataInd,      
      eMaxTypes
   }ECmdTypes;

   typedef struct TMsg{
      ECmdTypes  eCmd;
      tChar      strClassName[51];
      
      typedef struct {
          tU32 u32Len;
          tU8* pu8Data;
      }TDataTrailer;
      TDataTrailer tDataTrailer;
            
      union {
         tBool bData;
         tU8   u8Data;
         tS8   s8Data;
         tU16  u16Data;
         tS16  s16Data;
         tU32  u32Data;
         tS32  s32Data;
         tU8   au8Data[TIMESTAMPSYNCINTERNAL_MSG_LEN];
         typedef struct {
            tU16   u16MsgId;
            tU8    u8Opcode;
         } TMCanMsg;
         TMCanMsg tMCanMsg;

         // timestampsync_tclAppMainIMsgUnion: user specific code start
         // timestampsync_tclAppMainIMsgUnion: user specific code end
      }u;
   } TMsg;

   timestampsync_tclBaseIf(const timestampsync_tclAppMain* cpoMain):_cpoMain(cpoMain) {;} 
   virtual ~timestampsync_tclBaseIf() {_cpoMain = OSAL_NULL;} 
   virtual const tChar* getName() const = 0;
   virtual const tChar* getIfName() const = 0;

   virtual tVoid vHandleMessage(TMsg* pMsg) = 0;
   virtual tVoid vHandleTraceMessage(const tUChar* puchData) = 0;
   virtual tVoid vGetReferences() = 0;
   virtual tVoid vStartCommunication() = 0;
   virtual tVoid vTraceInfo() = 0;

   // timestampsync_tclAppMainBaseIfDecl: user specific code start
   // timestampsync_tclAppMainBaseIfDecl: user specific code end

};


class timestampsync_tclAppMain : public ahl_tclBaseOneThreadApp
{

private:
   static timestampsync_tclAppMain*   _poMainAppInstance;

public:
   static timestampsync_tclAppMain* theServer();    


   timestampsync_tclAppMain(tVoid);
   virtual ~timestampsync_tclAppMain(tVoid);

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'timestampsync_tclAppMain' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   timestampsync_tclAppMain& operator= (const timestampsync_tclAppMain &oApp);

   /**************************************************************************
   * Copy Constructor, will not be implemented.
   * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
   * 'timestampsync_tclAppMain' which has no copy constructor.
   * NOTE: This is a technique to disable the copy constructor for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   timestampsync_tclAppMain(const timestampsync_tclAppMain &oApp); 

   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadApp methods.
   **************************************************************************/
   virtual tBool bOnInit();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);   
   virtual tVoid vOnTimer(tU16 nTimerId);

   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   virtual tVoid vDispatchInternalMsg(timestampsync_tclBaseIf::TMsg* pInternalMsg);

#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostInternalMessage(timestampsync_tclBaseIf::TMsg* pInternalMsg);
#endif

   tVoid vAddObj(timestampsync_tclBaseIf* client) {
      _oObjList.insert(client);
   }

   tVoid vRemoveObj(timestampsync_tclBaseIf* client){
      if(_oObjList.find(client) != _oObjList.end()) {
         _oObjList.erase(_oObjList.find(client));
      }
   }

   tVoid vStart();
   tBool _bStartPerformed;   

   //reference handling for __ created objects
private:
   std::set<timestampsync_tclBaseIf*>  _oObjList;

public:
   tVoid vStartCommunication() const {
      std::set<timestampsync_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vStartCommunication();
      }
   }

   tVoid vGetReferences() const {
      std::set<timestampsync_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetReferences();
      }
   }

public:
   timestampsync_tclBaseIf*  getHandler(const tChar* cName) const{
      std::set<timestampsync_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (0 == OSAL_s32StringCompare((*iter)->getIfName(), cName)) {
            return (*iter);
         }
         if (0 == OSAL_s32StringCompare((*iter)->getName(), cName)) {
            return (*iter);
         }         
      }
      return NULL;
   }

   tVoid vLoadRegistry();

private:
   tVoid vTracePlugIn(tVoid);
   tVoid vTraceUnplug(tVoid);

   static tVoid vTraceCallbackFunction(const tUChar* puchData);
   static tVoid vHandleTraceMessage(const tUChar* puchData);
   static tVoid vHandleTraceMessageGen(const tUChar* puchData);

   static tUChar _auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE];

public:
#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostMsgSendTimeMSec(const tChar* strIfName, tU32 u32SendTimeMSec);
   virtual tVoid vPostMsgReceiveTimeMSec(const tChar* strIfName, tU32 u32ReceiveTimeMSec);
   virtual tVoid vPostMsgTimeDiffMSec(const tChar* strIfName, tU32 u32TimeDiffMSec);
   virtual tVoid vPostMsgTimeSyncActive(const tChar* strIfName, tBool bTimeSyncActive);
   virtual tVoid vPostMsgStartDelaySec(const tChar* strIfName, tU16 u16StartDelaySec);
   virtual tVoid vPostMsgCmdIncMsgReceived(const tChar* strIfName, tU8* au8CmdIncMsgReceived, tU32 length);
#endif

   // timestampsync_tclAppMainDecl: user specific code start
   // timestampsync_tclAppMainDecl: user specific code end
}; 

class tclMCanClientMsgInfo
{
private:
    tBool                   _bSendingInProgress;
    tU32                    _u32TimeStampSend;
    tU32                    _u32TimeStampReceived;
    tU32                    _u32DebounceIntervall;
    tU32                    _u32TimeStampTimeout;
    tU32                    _u32TimeStampSendEnabled;
    tU32                    _u32Timeout;
    tBool                   _bContentChanged;
    tBool                   _bEnabled;
    tBool                   _bConfiured;
    tBool                   _bForce;

public:
    typedef tBool (*T_SendFunction) (tVoid*);
    typedef tVoid (*T_TimeoutFunction) (tVoid*);
    T_SendFunction      pFuncSendMsg;
    T_TimeoutFunction   pFuncTimeoutMsg;

    std::vector < tU32 > _vecStateBlockedIn;
        
    tclMCanClientMsgInfo() :
        _bSendingInProgress(FALSE),
        _u32TimeStampSend(0),
        _u32TimeStampReceived(0),
        _u32DebounceIntervall(0),
        _u32TimeStampTimeout(0),
        _u32TimeStampSendEnabled(0),
        _u32Timeout(1500),
        _bContentChanged(TRUE),
        _bEnabled(TRUE),
        _bConfiured(TRUE),
        _bForce(FALSE),
         pFuncSendMsg(NULL) {};
    virtual ~tclMCanClientMsgInfo() {};

    tVoid vSetTimeout(tU32 u32Timeout) {_u32Timeout = u32Timeout;}
    tVoid vStartTimeoutDetection() {
        _bSendingInProgress   = TRUE;
        _u32TimeStampTimeout  = OSAL_ClockGetElapsedTime() + _u32Timeout;
    }
    tVoid vMsgSend() {
        _u32TimeStampSend     = OSAL_ClockGetElapsedTime();
        _bContentChanged      = FALSE;
        _u32TimeStampTimeout = _u32TimeStampSend + _u32DebounceIntervall;
        if ( (_u32DebounceIntervall != 0) && (_bForce)){
            _bContentChanged = TRUE;
        }
    }
    tVoid vMsgReceived(tBool bResetInSendingOnly = FALSE) {
        _bSendingInProgress = FALSE;
        if (!bResetInSendingOnly) _u32TimeStampReceived = OSAL_ClockGetElapsedTime();
    }
    tVoid vStartStatusSendPeriod() {
        _bEnabled = TRUE;
        _u32TimeStampSendEnabled = OSAL_ClockGetElapsedTime() + _u32Timeout;
    }

    tU32 u32GetLastSendTimestamp() {return _u32TimeStampSend;}
    tU32 u32GetLastRcvTimestamp() {return _u32TimeStampReceived;}

    tU32 u32MsgTimeout() {return _u32TimeStampTimeout;}
    tU32 u32GetMsgSendPeriodTimeout() {return _u32TimeStampSendEnabled;}

    tBool bSendingInProgress() {return _bSendingInProgress;}
    tVoid vDataChanged() {_bContentChanged = TRUE;}
    tBool bIsDataChanged() {return _bContentChanged;}
    tVoid vClearDataChanged() {_bContentChanged = FALSE;}

    tBool bIsMsgEnabled() {return _bEnabled;}
    tVoid vSetMsgEnabled(tBool bEnabled) {_bEnabled = bEnabled;}

    tBool bIsMsgConfigured() {return _bConfiured;}
    tVoid vSetMsgConfigured(tBool bConfiured) {_bConfiured = bConfiured;}

    tVoid vSetDebounceIntervall(tU32 u32Intervall) {_u32DebounceIntervall = u32Intervall;}
    tVoid vSetForceSend(tBool bForce) {_bForce = bForce;}
};
#endif // _TIMESTAMPSYNCMAIN_H_

