
/*****************************************************************************
* FILE:         timestampsync_fsm.h
* PROJECT:      G3G project
* SW-COMPONENT: timestampsync
* Template:     fsm.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#pragma once

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define TIMESTAMPSYNC_FSM_TRACE_ID_TRIGGER       0x3000
#define TIMESTAMPSYNC_FSM_TRACE_ID_NEW_STATE     0x3001
#define TIMESTAMPSYNC_FSM_TRACE_ID_NO_NEW_STATE  0x3002
#define TIMESTAMPSYNC_FSM_TRACE_ID_INFO          0x3003


#define FSM_U32_TRANSITION_ID_INVALID  0xFFFFFFFF
#define FSM_DONT_CARE                  0xFFFFFFFF

#define FSM_TRIGGER_STATE_TIMEOUT      0x80000000

class timestampsync_tclFsmBase {
public:
   typedef tVoid tFsmStateEntryFunc      (tVoid);
   typedef tVoid tFsmStateReachedFunc    (tVoid);
   typedef tVoid tFsmStateExitFunc       (tVoid);

   typedef struct {
      tU32 u32FsmState;
      tU32 u32Timeout;
      tFsmStateEntryFunc *pfnvStateEntry;
      tFsmStateReachedFunc *pfnvStateReached;
      tFsmStateExitFunc *pfnvStateExit;
   }TFsmStateConf;

   typedef struct
   {
      tU32 u32TransitionId;
      tU32 u32CurrentFsmState;
      tU32 u32UpdateTrigger;
      tU32 u32Trigger;
      tU32 u32TriggerNotSet;
      tU32 u32ActionId;
      tU32 u32NextFsmState;
   }TStateTransitions;

   tU32 u32GetFsmState() {return _u32FsmState;}
   tU32 u32GetFsmPrevState() {return _u32LastFsmState;}
   tU32 u32GetTrigger() {return _u32Trigger;}
   tVoid vTraceStatusInfo(tU32 RemainingTime = 0);

protected:
   tU32 _u32FsmState;
   tU32 _u32LastFsmState;

private:
   tU32 _u32CurrentTrigger;
   tU32 _u32Trigger;
   tU32 _u32CurrentTriggerUpdate;
   tU32 _u32TriggerUpdate;
   tU32 _u32LastTransitionId;
   tU32 _u32MaxStateEntry;
   tU32 _u32MaxTransitionEntry;
   tU32 _u32TimeOut;
   tU32 _u32TraceClass;

   TStateTransitions* _paFsmTransitionTable;

   TFsmStateConf* _paFsmStateTable;

   tVoid vActStateExit(tU32 u32FsmState);
   tU32 u32ActStateEntry(tU32 u32NewFsmState); 
   tVoid vActStateReached(tU32 u32FsmState); 

protected:

   //virtual tVoid vNewTrigger(tU32 u32Trigger, tBool bEnabled);
   virtual tVoid vSendTriggerViaWorker(tU32 u32Trigger, tBool bState);
   virtual tVoid vStateChangeDetected(tVoid);

   virtual tVoid vTransitionAction(tU32 u32ActionId) = 0;

   tU32 u32CalcNewFsmState(tU32 u32Trigger, tBool bState);

   virtual tVoid vStartFsmStateTimer(tU32 u32Time);
   tVoid vStateNoTransition();


   timestampsync_tclFsmBase(tU32 u32InitFsmSTate, tU32 u32MaxTransitionEntry, TStateTransitions* paFsmTransitionTable, tU32 u32MaxStateEntry, TFsmStateConf* paFsmStateTable, tU32 u32TraceClass);
   virtual ~timestampsync_tclFsmBase(); // destructor

};

