/*****************************************************************************
* FILE:         timestampsync_ClientEchoIncAdaptor.h
* PROJECT:      G3G project
* SW-COMPONENT: timestampsync
* Template:     incAdaptor.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _ECHOINCADAPTOR_H_
#define _ECHOINCADAPTOR_H_


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

#include "I_timestampsync_ClientEchoIncAdaptor.h"

class EchoIncCallbackIf;

class timestampsync_tclClientEchoIncAdaptor : public I_timestampsync_tclClientEchoIncAdaptor
{
private: 
    DatagramSocket*          _poDatagramSocket;
    EchoIncCallbackIf*   _poCallbackIf;
public:
    timestampsync_tclClientEchoIncAdaptor(timestampsync_tclAppMain* poMainAppl);
    timestampsync_tclClientEchoIncAdaptor(const timestampsync_tclClientEchoIncAdaptor& coRef);
    timestampsync_tclClientEchoIncAdaptor& operator=(const timestampsync_tclClientEchoIncAdaptor& coRef);

    virtual ~timestampsync_tclClientEchoIncAdaptor();

    virtual const tChar* getName() const { return "timestampsync_tclClientEchoIncAdaptor"; };
   
    virtual tVoid vHandleMessage(timestampsync_tclBaseIf::TMsg* pMsg);
    virtual tVoid vHandleTraceMessage(const tUChar* puchData);
    virtual tVoid vGetReferences();
    virtual tVoid vStartCommunication();
    virtual tVoid vTraceInfo();

    virtual tVoid vSetCallbackIf(EchoIncCallbackIf* poCallback) {
      _poCallbackIf = poCallback;
    }

    virtual tBool sendMessage(tU8* u8buf, tU32 ulen);

    // methods to send INC messages
    virtual tBool sendCOMPONENT_STATUS(::echo_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion);
    virtual tBool sendECHO(tU8 EchoComment);

private:

    virtual void onNewDatagramMessage(void* data, size_t length);
    virtual void vDispatchMessage(void* data, size_t length);
    
    // timestampsync_ECHOAdaptorAddClassPart: user specific code start
    // timestampsync_ECHOAdaptorAddClassPart: user specific code end

};

#endif // _ECHOINCADAPTOR_H_

