/*****************************************************************************
* FILE:         timestampsync_ClientEchoIncAdaptor.cpp
* PROJECT:      G3G project
* SW-COMPONENT: timestampsync
* Template:     incAdaptor.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

//include base class
#include "timestampsync_AppMain.h"

#include "Echo_incCallbackIf.h"
#include "timestampsync_ClientEchoIncAdaptor.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#include <dirent.h>
#include <mntent.h>

#include "inc.h"
#include "inc_ports.h"
#include "dgram_service.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_TIMESTAMPSYNC_CLIENT_ECHO
#include "trcGenProj/Header/timestampsync_ClientEchoIncAdaptor.cpp.trc.h"
#endif

// dispvidctrl_tclClientEchoIncAdaptorIncludes: user specific code start
// dispvidctrl_tclClientEchoIncAdaptorIncludes: user specific code end

/* ---------------- */
/* public functions */
/* ---------------- */

timestampsync_tclClientEchoIncAdaptor::timestampsync_tclClientEchoIncAdaptor(timestampsync_tclAppMain* poMainAppl) : 
I_timestampsync_tclClientEchoIncAdaptor(poMainAppl)
{

    ETG_TRACE_USR4(("timestampsync_tclClientEchoIncAdaptor::timestampsync_tclClientEchoIncAdaptor(): Called.... ."));

   _poDatagramSocket = new DatagramSocket(this, 8000, 100, ECHO_PORT, AF_BOSCH_INC_AUTOSAR, TRUE);
   _poCallbackIf     = OSAL_NULL;
   
   // timestampsync_tclClientEchoIncAdaptor::timestampsync_tclClientEchoIncAdaptor: user specific code start
   // timestampsync_tclClientEchoIncAdaptor::timestampsync_tclClientEchoIncAdaptor: user specific code end   
}

timestampsync_tclClientEchoIncAdaptor::~timestampsync_tclClientEchoIncAdaptor()
{

   ETG_TRACE_USR4(("timestampsync_tclClientEchoIncAdaptor::~timestampsync_tclClientEchoIncAdaptor(): Called.... ."));

   if( OSAL_NULL != _poDatagramSocket) {
      OSAL_DELETE _poDatagramSocket;
   }
   
   _poDatagramSocket = OSAL_NULL;
   _poCallbackIf     = OSAL_NULL;
}

tVoid timestampsync_tclClientEchoIncAdaptor::vHandleMessage(timestampsync_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("timestampsync_tclClientEchoIncAdaptor::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(timestampsync_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   if (pMsg->eCmd == timestampsync_tclBaseIf::eCmdIncMsgReceived) {
       vDispatchMessage(pMsg->u.au8Data, TIMESTAMPSYNCINTERNAL_MSG_LEN);
   }
   // timestampsync_tclClientEchoIncAdaptor::vHandleMessage: user specific code start
   // timestampsync_tclClientEchoIncAdaptor::vHandleMessage: user specific code end
}

tVoid timestampsync_tclClientEchoIncAdaptor::vHandleTraceMessage(const tUChar* puchData)
{
    TIMESTAMPSYNC_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("timestampsync_tclClientEchoIncAdaptor::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // timestampsync_tclClientEchoIncAdaptor::vHandleTraceMessage: user specific code start
   // timestampsync_tclClientEchoIncAdaptor::vHandleTraceMessage: user specific code end
}

tVoid timestampsync_tclClientEchoIncAdaptor::vGetReferences() {
   // timestampsync_tclClientEchoIncAdaptor::vGetReferences: user specific code start
   // timestampsync_tclClientEchoIncAdaptor::vGetReferences: user specific code end
}


tVoid timestampsync_tclClientEchoIncAdaptor::vTraceInfo()
{
   ETG_TRACE_USR4(("timestampsync_tclClientEchoIncAdaptor::vTraceInfo() entered."));
   // timestampsync_tclClientEchoIncAdaptor::vTraceInfo: user specific code start
   // timestampsync_tclClientEchoIncAdaptor::vTraceInfo: user specific code end

}


tVoid timestampsync_tclClientEchoIncAdaptor::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("timestampsync_tclClientEchoIncAdaptor::vStartCommunication() entered."));
   // timestampsync_tclClientEchoIncAdaptor::vStartCommunication: user specific code start
   // timestampsync_tclClientEchoIncAdaptor::vStartCommunication: user specific code end
}

tBool timestampsync_tclClientEchoIncAdaptor::sendMessage(tU8* u8buf, tU32 ulen) {

    tBool bRet = FALSE;
    ETG_TRACE_USR1(("timestampsync_tclClientEchoIncAdaptor::sendMessage(): Called.... ."));
    if (_poDatagramSocket) {
        ETG_TRACE_USR1(("timestampsync_tclClientEchoIncAdaptor::sendMessage():  Send message ID: %02x, datalen %d.", (tU8)u8buf[0], ulen));

        if (0 != _poDatagramSocket->sendMessage((void*)u8buf, ulen)) {
            bRet = TRUE;
        }
    }
    return bRet;
}

void timestampsync_tclClientEchoIncAdaptor::onNewDatagramMessage(void* data, size_t length)
{
    timestampsync_tclBaseIf::TMsg oMsg;
    (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
    oMsg.eCmd = timestampsync_tclBaseIf::eCmdIncMsgReceived;
    memset(oMsg.strClassName, 0, 50);
    OSAL_szStringNCopy(oMsg.strClassName, "I_timestampsync_tclClientEchoIncAdaptor", strlen("I_timestampsync_tclClientEchoIncAdaptor"));

    if (length <= TIMESTAMPSYNCINTERNAL_MSG_LEN) {
        (tVoid)OSAL_pvMemoryCopy(oMsg.u.au8Data, data, length);
        _cpoMain->theServer()->vPostInternalMessage(&oMsg);
    } else {
        ETG_TRACE_FATAL(("timestampsync_tclClientEchoIncAdaptor::onNewDatagramMessage(): message too long."));
        // timestampsync_tclClientEchoIncAdaptor::onNewDatagramMessage: user specific code start
        // timestampsync_tclClientEchoIncAdaptor::onNewDatagramMessage: user specific code end        
    }

}

void timestampsync_tclClientEchoIncAdaptor::vDispatchMessage(void* data, size_t length)
{
   tU8* pu8Data = (tU8*)data;
   ETG_TRACE_USR1(("timestampsync_tclClientEchoIncAdaptor::vDispatchMessage() entered -> data: %*x", ETG_LIST_LEN(length), ETG_LIST_PTR_T8((tU8*)data)));

   // timestampsync_tclClientEchoIncAdaptor::vDispatchMessage: user specific code start
   // timestampsync_tclClientEchoIncAdaptor::vDispatchMessage: user specific code end

   switch (pu8Data[0]) {
       case (tU8) ::echo_inc_fi::eECHO_PORT_R_COMPONENT_STATUS:
           if (_poCallbackIf) {
               _poCallbackIf->onCOMPONENT_STATUS((::echo_inc_fi::EApplicationStatus)pu8Data[1], (tU8)pu8Data[2]);
           }
           break;
       case (tU8) ::echo_inc_fi::eECHO_PORT_R_ECHO:
           if (_poCallbackIf) {
               _poCallbackIf->onECHO((tU8)pu8Data[1], (tU32)((tU32)pu8Data[5]<<24)|((tU32)pu8Data[4]<<16)|((tU32)pu8Data[3]<<8)|((tU32)pu8Data[2]));
           }
           break;
       default:
           break;
   }
}

tBool timestampsync_tclClientEchoIncAdaptor::sendCOMPONENT_STATUS(::echo_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    tU8 au8Data[] = {(tU8)::echo_inc_fi::eECHO_PORT_C_COMPONENT_STATUS, (tU8)ApplicationStatus, (tU8)ApplicationVersion};
    ETG_TRACE_USR4(("timestampsync_tclClientEchoIncAdaptor::sendCOMPONENT_STATUS(): INC interface is valid. Send now."));
    // timestampsync_tclClientEchoIncAdaptor::sendCOMPONENT_STATUS: user specific code start
    // timestampsync_tclClientEchoIncAdaptor::sendCOMPONENT_STATUS: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}
tBool timestampsync_tclClientEchoIncAdaptor::sendECHO(tU8 EchoComment) {
    tU8 au8Data[] = {(tU8)::echo_inc_fi::eECHO_PORT_C_ECHO, (tU8)EchoComment};
    ETG_TRACE_USR4(("timestampsync_tclClientEchoIncAdaptor::sendECHO(): INC interface is valid. Send now."));
    // timestampsync_tclClientEchoIncAdaptor::sendECHO: user specific code start
    // timestampsync_tclClientEchoIncAdaptor::sendECHO: user specific code end
    return sendMessage(au8Data, sizeof(au8Data));
}

// timestampsync_ECHOAdaptorAddClassPart: user specific code start
// timestampsync_ECHOAdaptorAddClassPart: user specific code end
