#ifndef _I_ECHOINCADAPTOR_H_
#define _I_ECHOINCADAPTOR_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          EchoIncCallbackIf.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: EchoIncCallbackIf
  * @Template:     IincAdaptor.h.tpl
  * @brief         generated file
  *                INC adapter
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include <list>

#include "DatagramSocket.h"
#include "DatagramSocketCallbackIf.h"

//include base class
#include "timestampsync_AppMain.h"

#include "timestampsync_ClientEchoIncFiDef.h"

class EchoIncCallbackIf;

class I_timestampsync_tclClientEchoIncAdaptor : public DatagramSocketCallbackIf,  public timestampsync_tclBaseIf
{
public:
    I_timestampsync_tclClientEchoIncAdaptor(timestampsync_tclAppMain* poMainAppl): timestampsync_tclBaseIf(poMainAppl) {;}
    virtual ~I_timestampsync_tclClientEchoIncAdaptor(){}

    virtual const tChar* getIfName() const { return "I_timestampsync_tclClientEchoIncAdaptor"; };

    virtual tVoid vSetCallbackIf(EchoIncCallbackIf* poCallback) = 0;

    // methods to send INC messages
    virtual tBool sendCOMPONENT_STATUS(::echo_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) = 0;
    virtual tBool sendECHO(tU8 EchoComment) = 0;

    // I_timestampsync_tclClientEchoIncAdaptor_AddClassPart: user specific code start
    // I_timestampsync_tclClientEchoIncAdaptor_AddClassPart: user specific code end
};

#endif // _I_ECHOINCADAPTOR_H_

