/*******************************************************************************
* FILE        :  timestampsync_ClientEcho_trace.cpp                                   
* DESCRIPTION :  Generated/Updated trace command message handler file 
* Template    :  client_trace.cpp.tpl
*******************************************************************************/

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          timestampsync_ClientEcho.cpp
  * @PROJECT:      CMD project
  * @SW-COMPONENT: timestampsync
  * @Template:     client_trace.cpp.tpl
  * @brief         generated file
  *                application trace interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "timestampsync_ClientEcho.h"

#include "timestampsync_AppMain_Trace.h"


// TR_CLASS_TIMESTAMPSYNC_CLIENT_ECHO_traceInclude: user specific code start
// TR_CLASS_TIMESTAMPSYNC_CLIENT_ECHO_traceInclude: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_TIMESTAMPSYNC_CLIENT_ECHO
#include "trcGenProj/Header/timestampsync_ClientEcho_trace.cpp.trc.h"
#endif

tVoid timestampsync_tclClientEcho::vHandleTraceMessage(const tUChar* puchData) {
    tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
    
    ETG_TRACE_USR1(("timestampsync_tclClientEcho::vHandleTraceMessage(): process command: %d.", u32MsgCode));
    
    switch (u32MsgCode) {

    case TIMESTAMPSYNC_TIMESTAMPSYNC_CMDCOMPONENT_STATUS:
        {
            // 
            tU32 param1 = ((tU32)puchData[3]<<24) | ((tU32)puchData[4]<<16) | ((tU32)puchData[5] << 8) | (tU32)puchData[6];
            tU8 param2 = puchData[7];
    

            // timestampsync_TIMESTAMPSYNC_CMDCOMPONENT_STATUS: user specific code start
            // timestampsync_TIMESTAMPSYNC_CMDCOMPONENT_STATUS: user specific code end
            onCOMPONENT_STATUS((::echo_inc_fi::EApplicationStatus)param1, param2);
        }
        break;
    case TIMESTAMPSYNC_TIMESTAMPSYNC_CMDECHO:
        {
            // 
            tU8 param1 = puchData[3];
            tU32 param2 = ((tU32)puchData[4]<<24) | ((tU32)puchData[5]<<16) | ((tU32)puchData[6] << 8) | (tU32)puchData[7];
    

            // timestampsync_TIMESTAMPSYNC_CMDECHO: user specific code start
            // timestampsync_TIMESTAMPSYNC_CMDECHO: user specific code end
            onECHO(param1, param2);
        }
        break;

    // timestampsync_tclClientEchoFunction_vHandleTraceMessageCase: user specific code start
    // timestampsync_tclClientEchoFunction_vHandleTraceMessageCase: user specific code end

    default:
        ETG_TRACE_USR4(("timestampsync_tclClientEcho::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
        break;
    }
    // timestampsync_tclClientEchoFunction_vHandleTraceMessage: user specific code start
    // timestampsync_tclClientEchoFunction_vHandleTraceMessage: user specific code end
    
    return;
}
// TR_CLASS_TIMESTAMPSYNC_CLIENT_ECHO_trace: user specific code start
// TR_CLASS_TIMESTAMPSYNC_CLIENT_ECHO_trace: user specific code end

