/*****************************************************************************
* FILE:         timestampsync_ClientEcho.cpp
* PROJECT:      CMD project
* SW-COMPONENT: timestampsync
* Template:     incProxy.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here INC handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
 * @copyright   (C) 2017 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
*****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "timestampsync_ClientEcho.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_TIMESTAMPSYNC_CLIENT_ECHO
#include "trcGenProj/Header/timestampsync_ClientEcho.cpp.trc.h"
#endif

// Echo_incProxy_tclMainIncludes: user specific code start
#include "Itimestampsync_ServiceEcho.h"
// Echo_incProxy_tclMainIncludes: user specific code end

/* ---------------- */
/* public functions */
/* ---------------- */

timestampsync_tclClientEcho::timestampsync_tclClientEcho(timestampsync_tclAppMain* poMainAppl):I_timestampsync_tclClientEcho(poMainAppl)
{
   _bAvailable = FALSE;
   _poThermalInc = OSAL_NULL;

   // timestampsync_tclClientEcho::timestampsync_tclClientEcho: user specific code start
   // timestampsync_tclClientEcho::timestampsync_tclClientEcho: user specific code end
   
   return;
}

timestampsync_tclClientEcho::~timestampsync_tclClientEcho(tVoid)
{
   _poThermalInc = OSAL_NULL;

   // timestampsync_tclClientEcho::~timestampsync_tclClientEcho: user specific code start
   // timestampsync_tclClientEcho::~timestampsync_tclClientEcho: user specific code end
}

tVoid timestampsync_tclClientEcho::vHandleMessage(timestampsync_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("timestampsync_tclClientEcho::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(timestampsync_tclBaseIf::ECmdTypes, pMsg->eCmd), pMsg->u.u32Data));
   // timestampsync_tclClientEcho::vHandleMessage: user specific code start
   // timestampsync_tclClientEcho::vHandleMessage: user specific code end

}

tVoid timestampsync_tclClientEcho::vGetReferences()
{
   ETG_TRACE_USR4(("timestampsync_tclClientEcho::vGetReferences() entered."));

   _poThermalInc = dynamic_cast<I_timestampsync_tclClientEchoIncAdaptor*>(_cpoMain->getHandler("I_timestampsync_tclClientEchoIncAdaptor"));
   TIMESTAMPSYNC_NULL_POINTER_CHECK(_poThermalInc);
   _poThermalInc->vSetCallbackIf(this);

   // timestampsync_tclClientEcho::vGetReferences: user specific code start
   // timestampsync_tclClientEcho::vGetReferences: user specific code end
}


tVoid timestampsync_tclClientEcho::vTraceInfo()
{
   ETG_TRACE_USR4(("timestampsync_tclClientEcho::vTraceInfo() entered."));
   // timestampsync_tclClientEcho::vTraceInfo: user specific code start
   // timestampsync_tclClientEcho::vTraceInfo: user specific code end
}


tVoid timestampsync_tclClientEcho::vStartCommunication(tVoid)
{
    ETG_TRACE_USR4(("timestampsync_tclClientEcho::vStartCommunication() entered."));
    if (sendCOMPONENT_STATUS() == FALSE) {
        ETG_TRACE_FATAL(("timestampsync_tclClientEcho::vStartCommunication(): Failed to send component state!!!"));
    }

    // timestampsync_tclClientEcho::vStartCommunication: user specific code start
    // timestampsync_tclClientEcho::vStartCommunication: user specific code end
}

void timestampsync_tclClientEcho::onCOMPONENT_STATUS(::echo_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    ETG_TRACE_USR1(("timestampsync_tclClientEcho::onCOMPONENT_STATUS():  Incomming msg: eECHO_PORT_R_COMPONENT_STATUS: ApplicationStatus: %u, ApplicationVersion: %d", ETG_ENUM(TIMESTAMPSYNC_ECHO_APPLICATIONSTATUS, ApplicationStatus), ApplicationVersion));

    if (ApplicationStatus == ::echo_inc_fi::eACTIVE) {
        _bAvailable = TRUE;
    }    

    // timestampsync_tclClientEcho_onCOMPONENT_STATUS: user specific code start
      Itimestampsync_tclServerEcho* _poEchoServerRef;
      _poEchoServerRef = dynamic_cast<Itimestampsync_tclServerEcho*>(_cpoMain->getHandler("Itimestampsync_tclServerEcho"));
      if ( _poEchoServerRef != NULL) {
         _poEchoServerRef->OnComponentStatus(_bAvailable);
      }
    // timestampsync_tclClientEcho_onCOMPONENT_STATUS: user specific code end
}
void timestampsync_tclClientEcho::onECHO(tU8 EchoResponse, tU32 TimeStamp) {
    ETG_TRACE_USR1(("timestampsync_tclClientEcho::onECHO():  Incomming msg: eECHO_PORT_R_ECHO: EchoResponse: %d, TimeStamp: %d", EchoResponse, TimeStamp));

    // timestampsync_tclClientEcho_onECHO: user specific code start
    if(TRUE == _bAvailable) {
      // inform echo server
      Itimestampsync_tclServerEcho* _poEchoServerRef;
      _poEchoServerRef = dynamic_cast<Itimestampsync_tclServerEcho*>(_cpoMain->getHandler("Itimestampsync_tclServerEcho"));
      if ( _poEchoServerRef != NULL) {
         _poEchoServerRef->OnEchoResponse(TimeStamp);
      }
    } else {
      ETG_TRACE_FATAL(("timestampsync_tclClientEcho::onECHO(): received without active connection!"));
    }
    // timestampsync_tclClientEcho_onECHO: user specific code end
}

tBool timestampsync_tclClientEcho::sendCOMPONENT_STATUS(::echo_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) {
    ETG_TRACE_USR1(("timestampsync_tclClientEcho::sendCOMPONENT_STATUS():  ApplicationStatus: %u, ApplicationVersion: %d", ETG_ENUM(TIMESTAMPSYNC_ECHO_APPLICATIONSTATUS, ApplicationStatus), ApplicationVersion));
    if (_poThermalInc) {
        return _poThermalInc->sendCOMPONENT_STATUS(ApplicationStatus, ApplicationVersion);
    }
    return FALSE;
}
tBool timestampsync_tclClientEcho::sendECHO(tU8 EchoComment) {
    ETG_TRACE_USR1(("timestampsync_tclClientEcho::sendECHO():  EchoComment: %d", EchoComment));
    if (_poThermalInc) {
        return _poThermalInc->sendECHO(EchoComment);
    }
    return FALSE;
}

// timestampsync_tclClientEchoAddClassPart: user specific code start
// timestampsync_tclClientEchoAddClassPart: user specific code end

//EOF
