/* ***************************************************************************************
* FILE:          NanoMsgMasterAppService.cpp
* SW-COMPONENT:  NanoMsgMasterAppService
* DESCRIPTION:  NanoMsgMasterAppService.cpp is the application initialization class
* COPYRIGHT:  (c) 2020-2021 Robert Bosch Car Multimedia GmbH
* Author: Supriya Seshadri
* Date: 03.02.2020
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
****************************************************************************************/


#include "NanoMsgMasterAppService.h"

#include "plugin_trace.h"
#include "clSenderThread.h"
#include "clReceiverThread.h"

#include "../TTFisCmdHandler/TTFisCmdHandler.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_NANOMSGMASTERASF
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES6
#define ETG_I_TTFIS_CMD_PREFIX            "NANOMESSAGEAPP"
#define ETG_I_FILE_PREFIX                 NANOMSGAPP::SERVICE
#include "trcGenProj/Header/NanoMsgMasterAppService.cpp.trc.h"
#endif
namespace NanoMsg_MasterApp {
	namespace NanoMsgServer {

/************************************************************************
*FUNCTION: 		NanoMsgMasterAppService()
*DESCRIPTION: 	Constructor of the NanoMsgMasterAppService Class, Entry point to the Service,
*				Called by the ASF Main
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	Supriya, Shivakumar J, Raju Doddamani	18/02/2020
************************************************************************/
NanoMsgMasterAppService::NanoMsgMasterAppService():m_psocketThread(NULL)
{
	vInitPlatformEtg();
	bool bSendSdnotify = TRUE;

	//Create the Sender thread Core instance
	if (NULL == clSenderThread::getInstance())
	{
		ETG_TRACE_USR4(("clSenderThread::getInstance() Failed to create"));
		bSendSdnotify = FALSE;
	}

	//Create Recv thread for receiving the messages
	if (NULL == clReceiverThread::getInstance())
	{
		ETG_TRACE_USR4(("clReceiverThread::getInstance() Failed to create"));
		bSendSdnotify = FALSE;
	}

	//Receive Nano Msg Socket thread
	m_psocketThread = new clSocketthread();
	if (NULL == m_psocketThread)
	{
		ETG_TRACE_USR4(("clSocketthread::getInstance() Failed to create"));
		bSendSdnotify = FALSE;
	}

	//Create the ASF LCM Adaptor 
	if (NULL == clAsfLCMServiceAdaptor::getInstance())
	{
		ETG_TRACE_USR4(("clAsfLCMServiceAdaptor::getInstance() Failed to create"));
		bSendSdnotify = FALSE;
	}

	//Create the ASF Intercom Adaptor Instance
	if (NULL == clAsfIntercomServiceAdaptor::getInstance())
	{
		ETG_TRACE_USR4(("clAsfIntercomServiceAdaptor::getInstance() Failed to create"));
		bSendSdnotify = FALSE;
	}

	//Create the ASF Generic Adaptor Instance
	if (NULL == clAsfGenericServiceAdaptor::getInstance())
	{
		ETG_TRACE_USR4(("clAsfGenericServiceAdaptor::getInstance() Failed to create"));
		bSendSdnotify = FALSE;
	}

	//Initialiase the TTFis Command Handler
	TTFisCmdHandler::initialize();

	if (!bSendSdnotify)
	{
		ETG_TRACE_FATAL(("bSendSdnotify is TRUE, Hence restart the Service"));
		//exit(-1); //to be commented out when we enable sd_notify
		//sd_notify(0, "ERRNO=2"); // No tested so far, so commented out
	}

	else {
		ETG_TRACE_USR4(("Sending sd_notify Ready!"));

		//object of sender thread instance
		/* 		sd_notifyf(0, "READY=1\n" // Tells the init system that daemon startup is finished.
		// This is only used by systemd if the service definition file has Type=notify set.
		"STATUS=Processing requests...\n" // Passes a single-line status string back to the init system that describes the daemon state.
		// This is free-form and can be used for various purposes
		"MAINPID=%lu\nPARENTID=%lu",
		(unsigned long)getpid(),
		(unsigned long)getppid() ); */
	}
	//todo: reciever thread of core module and sender thread of core module;

}

/************************************************************************
*FUNCTION: 		~NanoMsgMasterAppService()
*DESCRIPTION: 	Destructor of the NanoMsgMasterAppService Class, Exit point to the Service,
*				Called by the ASF Main
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	Supriya, Shivakumar J, Raju Doddamani	18/02/2020
*************************************************************************/
NanoMsgMasterAppService::~NanoMsgMasterAppService()
{
	clReceiverThread::vDeleteInstance();
	clSenderThread::vDeleteInstance();
	clAsfLCMServiceAdaptor::vDeleteInstance();
	clAsfIntercomServiceAdaptor::vDeleteInstance();
	clAsfGenericServiceAdaptor::vDeleteInstance();
	delete m_psocketThread;
}
}}//Namespace
