/* ***************************************************************************************
* FILE:          clAsfIntercomServiceAdaptor.h
* SW-COMPONENT:  HMI-BASE
 * DESCRIPTION:  clAsfIntercomServiceAdaptor.cpp is part of NanoMsgMasterApp
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Supriya Seshadri
 * Date: 03.02.2020
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef NANOMSGMASTER_INTECOMADAPTOR_H
#define NANOMSGMASTER_INTECOMADAPTOR_H

#include "NanoMsgIntercomInterfaceStub.h"
#include "NanoMsgIntercomInterfaceConst.h"
#include "clMsgIDMapping.h"
#include "NanoMsgReceiver.h"
#include <arpa/inet.h> 

using namespace ::bosch::cm::di::NanoMsgIntercomInterface;

namespace NanoMsg_MasterApp {
	namespace NanoMsgServer {

		class clAsfIntercomServiceAdaptor : public IBackendInterface,  
					public NanoMsgIntercomInterfaceStub
		{
		public:
			static clAsfIntercomServiceAdaptor* getInstance();
			static void vDeleteInstance();

			virtual ~clAsfIntercomServiceAdaptor();

			//Method Start Messages
			virtual void onEventHUCallRequest(const ::boost::shared_ptr< EventHUCallRequest >& request);
			virtual void onEventAcceptHUCallRequest(const ::boost::shared_ptr< EventAcceptHUCallRequest >& request) ;
			virtual void onEventCancelHUCallRequest(const ::boost::shared_ptr< EventCancelHUCallRequest >& request) ;
			virtual void onReqPhoneStatusRequest(const ::boost::shared_ptr< ReqPhoneStatusRequest >& request) ;
			virtual void onReqSetVolumeUpRequest(const ::boost::shared_ptr< ReqSetVolumeUpRequest >& request) ;
			virtual void onReqSetVolumeDownRequest(const ::boost::shared_ptr< ReqSetVolumeDownRequest >& request) ;
			virtual void onReqGetVolumeRequest(const ::boost::shared_ptr< ReqGetVolumeRequest >& request) ;
			virtual void onReqSetVolumeRequest(const ::boost::shared_ptr< ReqSetVolumeRequest >& request) ;
			virtual void onReqGetVersionRequest(const ::boost::shared_ptr< ReqGetVersionRequest >& request) ;
                        virtual void onReqGetIntercomAvailableRequest(const ::boost::shared_ptr< ReqGetIntercomAvailableRequest >& request) ;
		
			//Broadcast Messages
			void sendIntercomRspPhoneStatus(stNanoMsgData *data);
			void sendIntercomEventPhoneStatusChanged(stNanoMsgData *data);
			void sendIntercomEventIntercomCall(stNanoMsgData *data);
			void sendIntercomEventCancelIntercomCall(stNanoMsgData *data);
			void sendIntercomEventAcceptIntercomCall(stNanoMsgData *data);
			void sendIntercomRspGetVolume(stNanoMsgData *data);
			void sendIntercomEventSetVolume(stNanoMsgData *data);
			void sendIntercomRspGetVersion(stNanoMsgData *data);
                        void sendIntercomEventIntercomAvailable(stNanoMsgData *data);
                        void sendIntercomRspGetIntercomAvailable(stNanoMsgData *data);

		private:
			clAsfIntercomServiceAdaptor();
			static clAsfIntercomServiceAdaptor *p_clAsfIntercomServiceAdaptor;

			clAsfIntercomServiceAdaptor(const clAsfIntercomServiceAdaptor&);           // Prevent copy-construction
			clAsfIntercomServiceAdaptor& operator=(const clAsfIntercomServiceAdaptor&);      // Prevent assignment

			virtual bool init();
			clSenderThread *m_pcoreSenderThread;


		};
	}//Namespace NanoMsgServer
}

#endif // NANOMSGMASTER_APP_H
