/* ***************************************************************************************
 * FILE:          NanoMsgSender.cpp
 * SW-COMPONENT:  NanoMsg_Master_Application
 * DESCRIPTION:  NanoMsgSender.cpp is part of NanoMsg_MasterApplication
 * 				 This is the protocol part of the application, has the socket Sender implementation
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  02.02.2020
 * REVISION: Supriya S 18.03.2020
 *		Added the extraction of IP URL in the recieve logic, Data Length correction after receive
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#if !defined(EA_591DE218_E411_44a4_9DA8_F93B6BE2C3F2__INCLUDED_)
#define EA_591DE218_E411_44a4_9DA8_F93B6BE2C3F2__INCLUDED_

//#include "NanoMsgHandler.h"
#include "NanoMsgProtocolSetup.h"
#include "protocoldefines.h"
#include "clReceiverThread.h"
#include "clMsgIDMapping.h"
#include "Constants.h"
#include "DataPacket.h"
#include "Constants.h"

//todo check the nanomsghandler part
class clNanoMsgSender // : public tclNanoMsgHandler
{

public:
	clNanoMsgSender();
	virtual ~clNanoMsgSender();
	//tclEntityInfoStore m_tclEntityInfoStore;
	bool sendDataToEntity(stNanoMsgData data);
	
private:
	tHeader tsenderheader;
	//std::string getURLFromXML(int devID, int devNr);
	void init();
	void processRecvMsg(unsigned char* buffer, int recv_bytes);
    void vSendDummyRejectResponse(stNanoMsgData data);
	//Instance of the data packet class
	clMsgIDMapping *m_pIDMappingInstance;
	//XMLReader* m_pXmlReader;
	clReceiverThread *m_pCoreReceiver;

};
#endif // !defined(EA_591DE218_E411_44a4_9DA8_F93B6BE2C3F2__INCLUDED_)
