/************************************************************************
* FILE:         DataPacket.cpp
* PROJECT:      Inf4cv
* SW-COMPONENT: Messaging Framework for NanoMsg
*----------------------------------------------------------------------
*
* DESCRIPTION: For packing and unpacking of nanomsg NanoMsg protocol data
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2020 Robert Bosch GmbH
* HISTORY:
* Date      	| Author             		| Modification
* -----------------------------------------------------------------------------
* 09-02-2020   	Shivakumar J(RBEI/ECH2)		Initial Version
* 18.03.2020	Supriya S 					Rev 0.1
* Added the function vPackURL to convert bytes of IP data into a string of IP URL
*************************************************************************/

#include "DataPacket.h"
#include "includes.h"

#include "plugin_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_NANOMSGMASTERPROTOCOL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES6
#include "trcGenProj/Header/DataPacket.cpp.trc.h"
#endif

/************************************************************************
*FUNCTION: 		vSetSourceIp
*DESCRIPTION:   setting source ip for protocol
*PARAMETER:		tHeader &header
*RETURNVALUE: 	None
*History:		Supriya Seshadri(RBEI/ECG1)   Initial version
*************************************************************************/
//need to be called during constructor and store as a structure in global
//header memeber variable 
void clDataPacket::vSetSourceIp(struct tHeader &header)
{
	//@TODO Function required for getting SourceIp at run time
	//192.162.0.1
	header.u8source_ip[INDEX_IP_BASE] = CMC_HEADER_IP_FIRST_BYTE;
	header.u8source_ip[INDEX_IP_BASE_ONE] = CMC_HEADER_IP_SECOND_BYTE;
	header.u8source_ip[INDEX_IP_BASE_TWO] = CMC_HEADER_IP_THIRD_BYTE;
	header.u8source_ip[INDEX_IP_BASE_THREE] = CMC_HEADER_IP_FOURTH_BYTE;
}

/************************************************************************
*FUNCTION: 		vSetSourceMac
*DESCRIPTION:   setting source MAC for protocol
*PARAMETER:		tHeader &header
*RETURNVALUE: 	None
*History:		Supriya Seshadri(RBEI/ECG1)   Initial version
*************************************************************************/
void clDataPacket::vSetSourceMac(struct tHeader &header)
{
	//@TODO Function required for getting MAC at run time
	memcpy(header.u8source_mac,"0",6);
}

/************************************
/************************************************************************
*FUNCTION: 		vCreateNanoPacket(tHeader);
*DESCRIPTION:   Create the nanaPacket
*PARAMETER:		tHeader& header
*RETURNVALUE: 	None
*History:		Supriya Seshadri(RBEI/ECG5)   Initial version
*************************************************************************/
tNanoDataPack clDataPacket::vCreateNanoPacket(tHeader& header, stNanoMsgData tdata)
{
	ETG_TRACE_USR4(("clDataPacket::vCreateNanoPacket()"));

	tNanoDataPack nanopacket;
	//copying the Source Header to the Datapack
	nanopacket.headerData = header;
	
	// Copy the message id and the length from the obtained data from service
	nanopacket.headerData.u16typeLength = htons(nanopacket.headerData.u16typeLength + tdata.DataLength);
	
	//Message ID validity to be checked. 
	nanopacket.headerData.u16msgId = htons(tdata.MsgID);

	//copy the data buffer to the nano packet
	for (int itr = 0; itr < tdata.DataLength; itr++)
	{
		nanopacket.buffer[itr] = tdata.data[itr];
	}
	return nanopacket;
}

/************************************************************************
*FUNCTION: 		initCMCheader(tHeader);
*DESCRIPTION:   Initilaise the CMC Header data
*PARAMETER:		tHeader& header
*RETURNVALUE: 	None
*History:		Supriya Seshadri(RBEI/ECG5)   Initial version
*************************************************************************/
void clDataPacket::initCMCheader(tHeader& header)
{
	//@TODO: Optimization required
	header.u16version = htons(PROTOCOL_VERSION);
	header.u8devId = DEV_ID_CMC;
	header.u8devNumber = DEV_NUM_CMC;
	
	//DevID + DevNr + MsgID remains constant
	header.u16typeLength = DATA_HEADER_LENGTH;

	vSetSourceIp(header);
	vSetSourceMac(header);

}

/************************************************************************
*FUNCTION: 		vPackURL(URL, recvBufferData.strURL);
*DESCRIPTION:   Copies the URL IP into the str data
*PARAMETER:		URL[4] array of intergers, STD::STRING STRurl
*RETURNVALUE: 	None
*History:		Supriya Seshadri(RBEI/ECG1)   Initial version
*************************************************************************/
void clDataPacket::vPackURL(uint8_t URL[], std::string& strURL)
{
	char sbuffer[DATA_SIZE_FOUR_BYTE];
	for (int itr = 0; itr < DATA_SIZE_FOUR_BYTE; itr++)
	{
		sbuffer[itr] = URL[itr];
	}

	//Max 3 char for each bytes + 3 .s = 3X4 + 3 = 15 chars
	char str[16];

	sprintf(str, "%d.%d.%d.%d", sbuffer[0], sbuffer[1], sbuffer[2], sbuffer[3]);
	strURL = str;	
}


